import json
import base64


class Secrets(object):
    def __init__(self, global_dict):
        self.__variables_key_set = set()
        self.__global_scope_dict = global_dict

    # Initialise the kernel with a set of variables and their values
    # the json key is the variable name and the json value is the variable value
    def init_secrets(self, json_str):
        self.delete_all_secrets()
        config = json.loads(json_str)
        for key, value in config.items():
            self.assign_secret(key, value)

    # Add/Update a new/existing variable to the kernel.
    def assign_secret(self, encoded_key, encoded_value):
        key = base64.b64decode(encoded_key).decode("utf-8")
        value = base64.b64decode(encoded_value).decode("utf-8")
        self.__global_scope_dict[key] = value
        self.__variables_key_set.add(key)

    # clear the slate. this deletes all variables that were added
    def delete_all_secrets(self):
        for key in self.__variables_key_set:
            del self.__global_scope_dict[key]
        self.__variables_key_set = set()

    # delete one variable from the kernel
    def delete_secret(self, encoded_key):
        key = base64.b64decode(encoded_key).decode("utf-8")
        if key in self.__variables_key_set:
            del self.__global_scope_dict[key]
            self.__variables_key_set.discard(key)
