"""notebooksalamode.Dataset"""
import json
import os.path
import pandas as pd
import time

class Dataset(object):
    """Represets a Mode dataset"""

    data = None
    error = None
    name = None
    token = None
    file_type = None
    row_count = None
    column_count = None
    load_timeout = None

    def __init__(self, name, token, row_count=None, column_count=None, path=None, df=None, file_type="json", load_timeout=60):
        self.name = name
        self.token = token
        self.error = None
        self.file_type = file_type
        self.load_timeout = load_timeout

        if row_count is not None:
            self.row_count = row_count

        if column_count is not None:
            self.column_count = column_count

        if path is not None:
            self.path = path
            return

        if df is not None:
            self.data = df

    def load_json(self):
        self.data = pd.read_json(self.path, orient='records')
        self.error = False

    def load_csv(self):
        dtype_dict = self.load_dtype()
        self.data = pd.read_csv(self.path, encoding='utf8', dtype=dtype_dict)
        self.error = False

    def load(self):
        """Populates a Pandas dataframe for this Dataset"""
        i = 0
        while i < self.load_timeout:
            if os.path.isfile(self.path):
                if os.path.getsize(self.path) <= 0:
                    break

                if self.file_type == 'json':
                    return self.load_json()
                elif self.file_type == 'csv':
                    return self.load_csv()

                break

            time.sleep(1)
            i += 1

        self.data = pd.DataFrame({
            'Error Message' : ["Looks like a timeout occurred while loading your data. Please try reducing the size of your query."]
        })
        self.error = True

    def get_data(self):
        if self.data is None:
            self.load()

        return self.data

    def get_data_shape(self):
        if self.row_count is not None and self.column_count is not None:
            return self.row_count, self.column_count

        return self.get_data().shape

    def load_dtype(self):
        if os.path.exists(self.path + '.schema.json'):
            # Read the schema file
            with open(self.path + '.schema.json', 'r') as f:
                schema = json.load(f)

            # Extract column names with type 'string' from the schema DataFrame
            string_columns = [col['name'] for col in schema if col['type'] == 'string']

            # Create a dictionary with column names as keys and dtype as 'string'
            dtype_dict = {column: 'str' for column in string_columns}
            return dtype_dict
        else:
            return None
