## Setup

Create a new virtual environment and install the dependencies using `pipenv`:

* Install Python 3.11 using pyenv:
```pyenv install 3.11.0```

* Set Python 3.11 as the local version for your project:
```pyenv local 3.11.0```

* Create a new virtual environment using pyenv-virtualenv:
```pyenv virtualenv 3.11.0 my_project_env```

* Activate the new virtual environment:
```pyenv activate my_project_env```


This project uses [pipenv](https://github.com/pypa/pipenv) for package
management. To get started:
* `python3 -m pip install pipenv`
* `python3 -m pipenv install`
* `python3 -m pipenv run pytest`

## Note to Contributors

Ensure that you update `setup.py` with appropriate version bumps (minor or major) whenever changes are made.
