""" exportcsv """

import sys
from notebooksalamode.commstringio import CommStringIO

def export_csv(dataframe, sep=",", na_rep='', float_format=None, columns=None, header=True,
               index=True, index_label=None, encoding='utf8', quoting=None, quotechar='"',
               lineterminator='\n', date_format=None, doublequote=True, escapechar=None,
               decimal='.'):

    """export the provided dataframe to Mode"""
    comm = CommStringIO("csv_stream")
    try:
        dataframe.to_csv(comm,
                         sep=sep,
                         na_rep=na_rep,
                         float_format=float_format,
                         columns=columns,
                         header=header,
                         index=index,
                         index_label=index_label,
                         encoding=encoding,
                         quoting=quoting,
                         quotechar=quotechar,
                         lineterminator=lineterminator,
                         date_format=date_format,
                         doublequote=doublequote,
                         escapechar=escapechar,
                         decimal=decimal)

        # switch to utf8 to fix this class of error
        # dataframe.to_csv(comm, encoding="utf8")
    except Exception as e:
        sys.stderr.write(e.__str__())
        comm.write("# Error generating CSV. More data may be available")
    finally:
        comm.close()
