/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager;

import java.util.function.Consumer;

public class Wrapper<T> {
    private final T data;
    private final boolean updated;
    private boolean changed;
    private String oldVersion;
    private String newVersion;

    private Wrapper(T data) {
        this(data, false, false);
    }

    public Wrapper(T data, boolean updated) {
        this(data, updated, false);
    }

    public Wrapper(T data, boolean updated, boolean changed) {
        this.data = data;
        this.updated = updated;
        this.changed = changed;
    }

    public static <T> Wrapper<T> notUpdated(T data) {
        return new Wrapper(data);
    }

    public static <T> Wrapper<T> updated(T data) {
        return new Wrapper(data, true);
    }

    public Wrapper<T> changed(boolean changed) {
        this.changed = changed;
        return this;
    }

    public Wrapper<T> withOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
        return this;
    }

    public Wrapper<T> withNewVersion(String newVersion) {
        this.newVersion = newVersion;
        return this;
    }

    public void ifUpdated(Consumer<T> consumer) {
        if (this.updated) {
            consumer.accept(this.data);
        }
    }

    public void ifChangedOrElseIfUpdated(Consumer<T> onChanged, Consumer<T> onUpdated) {
        if (this.changed) {
            onChanged.accept(this.data);
        } else if (this.updated) {
            onUpdated.accept(this.data);
        }
    }

    public void ifChanged(Consumer<T> consumer) {
        if (this.changed) {
            consumer.accept(this.data);
        }
    }

    public T getData() {
        return (T)this.data;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public boolean isChanged() {
        return this.changed;
    }
}

