/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility.crypto;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class Encoder {
    private static final String DEFAULT_SECRET_KEY = "It's a secret key";
    private static final String SALT = "opencelium-salt";
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH = 256;
    private static final int ITERATION_COUNT = 65536;
    private final SecretKeySpec secretKeySpec;
    private final SecureRandom secureRandom;
    private final String secretKey;

    @Autowired
    public Encoder(Environment environment) {
        this.secretKey = environment.getProperty("opencelium.connector.security.key", DEFAULT_SECRET_KEY);
        try {
            this.secretKeySpec = this.generateSecretKeySpec(this.secretKey);
            this.secureRandom = new SecureRandom();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing encoder", e);
        }
    }

    public Encoder(String secretKey) {
        this.secretKey = secretKey;
        try {
            this.secretKeySpec = this.generateSecretKeySpec(secretKey);
            this.secureRandom = new SecureRandom();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing encoder", e);
        }
    }

    private SecretKeySpec generateSecretKeySpec(String secretKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(secretKey.toCharArray(), SALT.getBytes(), 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    public String decrypt(String strToDecrypt) {
        try {
            byte[] encryptedData = Base64.getDecoder().decode(strToDecrypt);
            IvParameterSpec ivspec = new IvParameterSpec(encryptedData, 0, 16);
            Cipher decryptCipher = Cipher.getInstance(ALGORITHM);
            decryptCipher.init(2, (Key)this.secretKeySpec, ivspec);
            byte[] decryptedText = decryptCipher.doFinal(encryptedData, 16, encryptedData.length - 16);
            return new String(decryptedText, StandardCharsets.UTF_8);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Decryption failed due to bad padding. Check if the key is correct.");
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Decryption failed due to illegal block size. Data may be corrupted.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Error during decryption", e);
        }
    }

    public String encrypt(String strToEncrypt) {
        try {
            byte[] iv = new byte[16];
            this.secureRandom.nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher encryptCipher = Cipher.getInstance(ALGORITHM);
            encryptCipher.init(1, (Key)this.secretKeySpec, ivspec);
            byte[] cipherText = encryptCipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8));
            byte[] encryptedData = new byte[iv.length + cipherText.length];
            System.arraycopy(iv, 0, encryptedData, 0, iv.length);
            System.arraycopy(cipherText, 0, encryptedData, iv.length, cipherText.length);
            return Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Encryption error. Possible padding issue.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Error during encryption", e);
        }
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

