/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import com.becon.opencelium.backend.invoker.resource.FieldResource;
import com.becon.opencelium.backend.invoker.resource.OperationResource;
import com.becon.opencelium.backend.utility.FileNameUtils;
import com.becon.opencelium.backend.utility.PathUtility;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Xml {
    private Document document;
    private XPathFactory xPathfactory = XPathFactory.newInstance();
    private XPath xpath = this.xPathfactory.newXPath();
    private String fileName;
    private String format;

    public Xml(Document document) {
        this.document = document;
    }

    public Xml(String document) {
        this.document = Xml.convertStringToDocument((String)document);
    }

    public Xml(Document document, String fileName) {
        this.document = document;
        this.format = document.getElementsByTagName("invoker").item(0).getAttributes().getNamedItem("type").getNodeValue();
        this.fileName = FileNameUtils.getExtension((String)fileName).equalsIgnoreCase("xml") ? fileName : fileName + ".xml";
    }

    public String toString(Object xmlMap) {
        Map map = (Map)xmlMap;
        Map.Entry entry = map.entrySet().iterator().next();
        Element element = this.document.createElement((String)entry.getKey());
        this.document.appendChild(element);
        if (!(entry.getValue() instanceof Map)) {
            throw new RuntimeException("Couldn't find root element");
        }
        Map a1 = (Map)entry.getValue();
        List attrs = this.getAttributes((Object)a1);
        this.mapToNode(a1).forEach(element::appendChild);
        if (attrs != null) {
            attrs.forEach(element::setAttributeNode);
        }
        return this.nodeToString((Node)element);
    }

    public List<Element> createFields(List<FieldResource> fields) {
        return fields.stream().map(arg_0 -> this.createField(arg_0)).collect(Collectors.toList());
    }

    public List<Element> createXmlFields(List<FieldResource> fields) {
        return fields.stream().map(arg_0 -> this.createXmlField(arg_0)).collect(Collectors.toList());
    }

    public Element createField(FieldResource field) {
        Element element = this.document.createElement("field");
        element.setAttribute("name", field.getName());
        element.setAttribute("type", field.getType());
        if (field.getValue() != null) {
            element.setTextContent(field.getValue().toString());
        }
        return element;
    }

    public Element createXmlField(FieldResource field) {
        Element element = this.document.createElement("field");
        element.setAttribute("name", field.getName());
        element.setAttribute("type", "object");
        Element attr = this.document.createElement("field");
        attr.setAttribute("name", "__oc__attributes");
        attr.setAttribute("type", "object");
        Element value = this.document.createElement("field");
        value.setAttribute("name", "__oc__value");
        value.setAttribute("type", "string");
        if (field.getValue() != null) {
            value.setTextContent(field.getValue().toString());
        }
        element.appendChild(attr);
        element.appendChild(value);
        return element;
    }

    public NodeList getNodeListByXpath(String xPath) throws XPathExpressionException {
        return (NodeList)this.xpath.compile(xPath).evaluate(this.document, XPathConstants.NODESET);
    }

    public void addFields(String xPath, OperationResource operationResource) throws XPathExpressionException {
        List fields;
        NodeList nl = this.getNodeListByXpath(xPath);
        if (!this.pathExists(xPath)) {
            nl = this.addNewFieldFromPath(operationResource);
        }
        List list = fields = this.format.equalsIgnoreCase("restful") ? this.createFields(operationResource.getFields()) : this.createXmlFields(operationResource.getFields());
        if (this.pathExists(xPath)) {
            for (Element e : fields) {
                String field = xPath + "/field[@name='" + e.getAttributeNode("name").getValue() + "']";
                try {
                    if (this.pathExists(field)) {
                        Node oldField = this.getNodeListByXpath(field).item(0);
                        nl.item(0).replaceChild(e, oldField);
                        return;
                    }
                    assert (nl != null);
                    nl.item(0).appendChild(e);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private NodeList addNewFieldFromPath(OperationResource operationResource) throws XPathExpressionException {
        Object xBody = PathUtility.getXPathTillBody((String)operationResource.getPath(), (String)operationResource.getMethod());
        NodeList node = this.getNodeListByXpath((String)xBody);
        String[] fields = PathUtility.getFields((String)operationResource.getPath()).split("\\.");
        boolean hasNewField = false;
        for (String f : fields) {
            FieldResource fr = this.createFieldResource(f);
            String xField = PathUtility.convretToXField((String)fr.getName());
            xBody = (String)xBody + "/" + xField;
            if (!hasNewField && this.pathExists((String)xBody)) {
                node = this.getNodeListByXpath((String)xBody);
                hasNewField = false;
                continue;
            }
            Element field = this.format.equalsIgnoreCase("restful") ? this.createField(fr) : this.createXmlField(fr);
            node.item(0).appendChild(field);
            node = node.item(0).getChildNodes();
            hasNewField = true;
        }
        return node;
    }

    public String getValueByXPath(String xPath) throws XPathExpressionException {
        return this.xpath.compile(xPath).evaluate(this.document, XPathConstants.STRING).toString();
    }

    private FieldResource createFieldResource(String field) {
        String type = field.contains("[]") ? "array" : "object";
        String name = field.replace("[]", "");
        FieldResource fieldResource = new FieldResource();
        fieldResource.setName(name);
        fieldResource.setType(type);
        return fieldResource;
    }

    public NodeList findElementInNodeList(NodeList nodeList, String xPath) throws XPathExpressionException {
        return (NodeList)this.xpath.compile(xPath).evaluate(nodeList, XPathConstants.NODESET);
    }

    public boolean pathExists(String xPath) throws XPathExpressionException {
        return this.getNodeListByXpath(xPath).item(0) != null;
    }

    public void save() throws FileNotFoundException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.document);
        String f = "runtime/invoker/" + this.fileName;
        FileOutputStream output = new FileOutputStream(f);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    private List<Element> mapToNode(Map<String, Object> map) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Map.Entry<String, Object> tag : map.entrySet()) {
            String ocValue;
            if (tag.getKey().equals("__oc__attributes") || tag.getKey().equals("__oc__value")) continue;
            Element element = this.document.createElement(tag.getKey());
            if (tag.getValue() instanceof List) {
                List arrayItems = (List)tag.getValue();
                for (Map item : arrayItems) {
                    String ocValue2;
                    element = this.document.createElement(tag.getKey());
                    List attrs = this.getAttributes((Object)item);
                    if (attrs != null) {
                        attrs.forEach(element::setAttributeNode);
                    }
                    if ((ocValue2 = this.getOcValue((Object)item)) != null && !ocValue2.isEmpty()) {
                        element.appendChild(this.document.createTextNode(ocValue2));
                        elements.add(element);
                        continue;
                    }
                    List childElem = this.mapToNode(item);
                    childElem.forEach(element::appendChild);
                    elements.add(element);
                }
                continue;
            }
            List attrs = null;
            if (tag.getValue() instanceof Map) {
                attrs = this.getAttributes(tag.getValue());
            }
            if (attrs != null) {
                attrs.forEach(element::setAttributeNode);
            }
            if ((ocValue = this.getOcValue(tag.getValue())) != null) {
                element.appendChild(this.document.createTextNode(ocValue));
                elements.add(element);
                continue;
            }
            List childElem = this.mapToNode((Map)tag.getValue());
            childElem.forEach(element::appendChild);
            elements.add(element);
        }
        return elements;
    }

    private boolean isArray(Object object) {
        return object instanceof ArrayList;
    }

    private String getOcValue(Object object) {
        if (!(object instanceof Map)) {
            return "";
        }
        Map tag = (Map)object;
        if (!tag.containsKey("__oc__value") || tag.get("__oc__value") == null || tag.get("__oc__value") instanceof Map) {
            return null;
        }
        Object v = tag.get("__oc__value");
        if (v instanceof Integer) {
            return Integer.toString((Integer)v);
        }
        if (v instanceof Double) {
            return Double.toString((Double)v);
        }
        if (v instanceof Float) {
            return Float.toString(((Float)v).floatValue());
        }
        return (String)tag.get("__oc__value");
    }

    private List<Attr> getAttributes(Object object) {
        if (!(object instanceof Map)) {
            throw new RuntimeException("Attributes is not an object");
        }
        Map tag = (Map)object;
        Map attrsMap = null;
        if (tag.get("__oc__attributes") instanceof Map) {
            attrsMap = (Map)tag.get("__oc__attributes");
        }
        if (attrsMap == null) {
            return null;
        }
        ArrayList<Attr> attrs = new ArrayList<Attr>();
        for (Map.Entry attr : attrsMap.entrySet()) {
            String key = (String)attr.getKey();
            String value = (String)attr.getValue();
            Attr attribute = this.document.createAttribute(key);
            attribute.setValue(value);
            attrs.add(attribute);
        }
        return attrs;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            System.out.println("nodeToString Transformer Exception");
        }
        return sw.toString();
    }

    private static Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

