/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MachineUtility {
    private static final Logger logger = LoggerFactory.getLogger(MachineUtility.class);

    private MachineUtility() {
    }

    public static String getMachineUUID() {
        String command;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            command = "wmic csproduct get UUID";
        } else if (os.contains("mac")) {
            command = "system_profiler SPHardwareDataType | grep 'Hardware UUID' | awk '{print $3}'";
        } else if (os.contains("nix") || os.contains("nux")) {
            command = "sudo dmidecode -s system-uuid";
        } else {
            logger.error("Unsupported OS: " + os);
            return "0";
        }
        String machineUuid = MachineUtility.executeCommand((String)command);
        return machineUuid == null || machineUuid.isEmpty() ? "0" : machineUuid;
    }

    public static String getMacAddress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost == null) {
                return "0";
            }
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
            if (networkInterface == null) {
                return "0";
            }
            byte[] macBytes = networkInterface.getHardwareAddress();
            if (macBytes == null) {
                return "0";
            }
            StringBuilder macAddress = new StringBuilder();
            for (int i = 0; i < macBytes.length; ++i) {
                macAddress.append(String.format("%02X", macBytes[i]));
                if (i >= macBytes.length - 1) continue;
                macAddress.append("-");
            }
            return macAddress.isEmpty() ? "0" : macAddress.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "0";
        }
    }

    public static String getSystemUuid() {
        String command;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            command = "wmic bios get serialnumber";
        } else if (os.contains("mac")) {
            command = "system_profiler SPHardwareDataType | awk '/Serial/ {print $4}'";
        } else if (os.contains("nix") || os.contains("nux")) {
            command = "sudo dmidecode -s system-serial-number";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + os);
        }
        String systemUuid = MachineUtility.executeCommand((String)command);
        return systemUuid == null || systemUuid.isEmpty() ? "0" : systemUuid;
    }

    public static String getComputerName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName() == null ? "ComputerName n/a" : localHost.getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ComputerName n/a";
        }
    }

    public static String getStringForHmacEncode() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Machine UUID", MachineUtility.getMachineUUID());
        parameters.put("MAC Address", MachineUtility.getMacAddress());
        parameters.put("System UUID", MachineUtility.getSystemUuid());
        parameters.put("Computer Name", MachineUtility.getComputerName());
        StringBuilder missingParameters = new StringBuilder();
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : parameters.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) {
                missingParameters.append((String)entry.getKey()).append(" is empty. ");
                continue;
            }
            result.append(value);
        }
        if (missingParameters.length() > 0) {
            throw new IllegalArgumentException(missingParameters + "Please grant permissions.");
        }
        return result.toString();
    }

    private static String executeCommand(String command) {
        StringBuilder result = new StringBuilder();
        try {
            String[] lines;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                builder.command("cmd.exe", "/c", command);
            } else {
                builder.command("sh", "-c", command);
            }
            Process process = builder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            process.waitFor();
            String output = result.toString().trim();
            if (command.contains("wmic") && (lines = output.split("\\R")).length > 1) {
                output = lines[1].trim();
            }
            return output.isEmpty() ? "" : output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

