/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.template.service;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.exception.WrongEncode;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.old.ConnectionOldDTO;
import com.becon.opencelium.backend.resource.template.CtionTemplateResource;
import com.becon.opencelium.backend.resource.template.TemplateResource;
import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.template.service.TemplateService;
import com.becon.opencelium.backend.utility.FileNameUtils;
import com.becon.opencelium.backend.versionmanager.EntityUpdater;
import com.becon.opencelium.backend.versionmanager.EntityVersionManager;
import com.becon.opencelium.backend.versionmanager.backup.FileBackupManager;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImp
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImp.class);
    private final ConnectionService connectionService;
    private final Mapper<ConnectionOldDTO, CtionTemplateResource> mapper;
    private final Mapper<ConnectionDTO, ConnectionOldDTO> oldDTOMapper;
    private final OpenceliumProps ocProps;
    private final EntityUpdater<Template> templateEntityUpdater;
    private final ObjectMapper objectMapper;

    public TemplateServiceImp(@Qualifier(value="connectionServiceImp") ConnectionService connectionService, Mapper<ConnectionOldDTO, CtionTemplateResource> mapper, Mapper<ConnectionDTO, ConnectionOldDTO> oldDTOMapper, EntityVersionManager entityVersionManager, OpenceliumProps ocProps, @Qualifier(value="objectMapper") ObjectMapper objectMapper) {
        this.connectionService = connectionService;
        this.mapper = mapper;
        this.oldDTOMapper = oldDTOMapper;
        this.ocProps = ocProps;
        this.templateEntityUpdater = entityVersionManager.getUpdater(Template.class);
        this.objectMapper = objectMapper;
    }

    public TemplateResource toResource(Template template) {
        TemplateResource templateResource = new TemplateResource();
        templateResource.setName(template.getName());
        templateResource.setTemplateId(template.getTemplateId());
        templateResource.setDescription(template.getDescription());
        templateResource.setVersion(template.getVersion());
        templateResource.setConnection(template.getConnection());
        templateResource.setLink("./template/" + template.getTemplateId());
        return templateResource;
    }

    public Template toEntity(TemplateResource templateResource) {
        Template template = new Template();
        template.setTemplateId(templateResource.getTemplateId());
        template.setName(templateResource.getName());
        template.setTemplateId(templateResource.getTemplateId());
        template.setDescription(templateResource.getDescription());
        template.setConnection(templateResource.getConnection());
        template.setVersion(templateResource.getVersion());
        return template;
    }

    public void save(Template template) {
        this.save(template, template.getTemplateId() + ".json");
    }

    public List<Template> findByFromInvokerAndToInvoker(String fromInvoker, String toInvoker) {
        ArrayList<Template> result = new ArrayList<Template>();
        this.getAll("runtime/templates/").forEach(t -> {
            if (t == null) {
                return;
            }
            String invNameFrom = t.getConnection().getFromConnector().getInvoker().getName().toUpperCase();
            String invNameTo = t.getConnection().getToConnector().getInvoker().getName().toUpperCase();
            if (invNameFrom.equals(fromInvoker.toUpperCase()) && invNameTo.equals(toInvoker.toUpperCase())) {
                result.add((Template)t);
            }
        });
        return result;
    }

    public List<Template> findAll() {
        return this.getAll("runtime/templates/");
    }

    public List<Template> findAllByPath(String path) {
        return this.getAll(path);
    }

    public boolean existsById(String templateId) {
        List templates = this.getAll("runtime/templates/");
        return templateId == null || templates.stream().anyMatch(t -> t.getTemplateId().equals(templateId));
    }

    public TemplateResource getByConnectionId(Long connectionId) {
        ConnectionDTO connectionDTO = this.connectionService.getFullConnection(connectionId);
        ConnectionOldDTO oldDTO = (ConnectionOldDTO)this.oldDTOMapper.toDTO((Object)connectionDTO);
        CtionTemplateResource connectionRes = (CtionTemplateResource)this.mapper.toDTO((Object)oldDTO);
        TemplateResource templateResource = new TemplateResource();
        templateResource.setConnection(connectionRes);
        templateResource.setName(connectionRes.getTitle());
        templateResource.setDescription(connectionRes.getDescription());
        templateResource.setTemplateId(UUID.randomUUID().toString());
        templateResource.setVersion(this.ocProps.getVersion());
        return templateResource;
    }

    public void updateTemplatesToCurrentVersion() {
        this.moveTemplatesToNewLocation();
        Map templateMap = this.getAllAsMap();
        for (Map.Entry entry : templateMap.entrySet()) {
            Template backup;
            String fileName = (String)entry.getKey();
            Template template = (Template)entry.getValue();
            try {
                backup = (Template)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)template), Template.class);
            }
            catch (JsonProcessingException e) {
                log.error("Error while reading template Template[id={}, name={}]", (Object)template.getTemplateId(), (Object)template.getName());
                continue;
            }
            if (Utils.compare((String)this.ocProps.getVersion(), (String)template.getVersion()) <= 0) continue;
            try {
                String oldVersion = template.getVersion();
                this.templateEntityUpdater.updateToCurrentVersion((Object)template).ifUpdated(x -> {
                    template.setVersion(this.ocProps.getVersion());
                    FileBackupManager.doBackup((Template)backup, (String)oldVersion, (String)this.ocProps.getVersion());
                    this.save(template, fileName);
                    log.info("Template[id={}, name={}] is successfully updated to {} version", new Object[]{template.getTemplateId(), template.getName(), this.ocProps.getVersion()});
                });
            }
            catch (Exception e) {
                log.error("Failed to update Template[id={}, name={}]", new Object[]{template.getTemplateId(), template.getName(), e});
            }
        }
    }

    private void moveTemplatesToNewLocation() {
        List templatesInResources = this.getAllPaths("src/main/resources/templates");
        templatesInResources.forEach(x -> {
            try {
                Files.move(x, Paths.get("runtime/templates/", new String[0]).resolve(x.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error("Failed to move {} file from {} to {}", new Object[]{x, "src/main/resources/templates", "runtime/templates/"});
                throw new RuntimeException(e);
            }
        });
        try {
            Files.deleteIfExists(Path.of("src/main/resources/templates", new String[0]));
        }
        catch (IOException e) {
            log.error("Failed to remove folder {}", (Object)"src/main/resources/templates");
        }
    }

    public void deleteById(String templateId) {
        Map templates = this.getAllAsMap();
        String fileName = templates.entrySet().stream().filter(entry -> ((Template)entry.getValue()).getTemplateId().equals(templateId)).findFirst().map(entry -> (String)entry.getKey()).orElse(null);
        if (fileName == null) {
            throw new RuntimeException("FILE_NOT_FOUND");
        }
        File file = Paths.get("runtime/templates/", new String[0]).resolve(fileName).toFile();
        if (!file.delete()) {
            throw new RuntimeException("FILE_NOT_DELETED");
        }
    }

    public Optional<Template> findById(String id) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get("runtime/templates/", new String[0]).resolve(id.concat(".json")), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Template template = (Template)objectMapper.readValue(contentBuilder.toString(), Template.class);
            return Optional.of(template);
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR while converting from json to Template object");
        }
    }

    private void save(Template template, String fileName) {
        try {
            String id = template.getTemplateId();
            ObjectMapper objectMapper = new ObjectMapper();
            template.setTemplateId(id);
            Path filePath = Paths.get("runtime/templates/", new String[0]).resolve(fileName);
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                objectMapper.writeValue((Writer)writer, (Object)template);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Template> getAll(String folder) throws WrongEncode {
        List<Template> list;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> FileNameUtils.getExtension((String)path.toString()).equals("json")).map(path -> {
                    Template template;
                    block8: {
                        StringBuilder contentBuilder = new StringBuilder();
                        Stream<String> stream = Files.lines(Paths.get(path.toString(), new String[0]), StandardCharsets.UTF_8);
                        try {
                            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                            template = (Template)objectMapper.readValue(contentBuilder.toString(), Template.class);
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new WrongEncode("UTF8");
                            }
                        }
                        stream.close();
                    }
                    return template;
                }).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }

    private Map<String, Template> getAllAsMap() {
        Map<String, Template> map;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get("runtime/templates/", new String[0]), new FileVisitOption[0]);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                map = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
                    try {
                        String json = Files.readString(path, StandardCharsets.UTF_8);
                        return (Template)objectMapper.readValue(json, Template.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read template: " + path, e);
                    }
                }));
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return map;
    }

    private List<Path> getAllPaths(String folder) {
        List<Path> list;
        block9: {
            if (Files.notExists(Paths.get(folder, new String[0]), new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> walk = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);
            try {
                list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> FileNameUtils.getExtension((String)path.toString()).equals("json")).map(Path::toAbsolutePath).toList();
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }
}

