/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.storage;

import com.becon.opencelium.backend.exception.StorageException;
import com.becon.opencelium.backend.exception.StorageFileNotFoundException;
import com.becon.opencelium.backend.storage.StorageProperties;
import com.becon.opencelium.backend.storage.StorageService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserStorageService
implements StorageService {
    private final Path rootLocation;

    @Autowired
    public UserStorageService(StorageProperties properties) {
        this.rootLocation = Paths.get(properties.getLocation(), new String[0]);
    }

    public void init() {
        try {
            Files.createDirectories(this.rootLocation, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageException("Could not initialize storage", (Throwable)e);
        }
    }

    public void store(MultipartFile file, String filename) {
        try {
            if (file.isEmpty()) {
                throw new StorageException("Failed to store empty file " + filename);
            }
            if (filename.contains("..")) {
                throw new StorageException("Cannot store file with relative path outside current directory " + filename);
            }
            try (InputStream inputStream = file.getInputStream();){
                Files.copy(inputStream, this.rootLocation.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to store file " + filename, (Throwable)e);
        }
    }

    public Stream<Path> loadAll() {
        try {
            return Files.walk(this.rootLocation, 1, new FileVisitOption[0]).filter(path -> !path.equals(this.rootLocation)).map(this.rootLocation::relativize);
        }
        catch (IOException e) {
            throw new StorageException("Failed to read stored files", (Throwable)e);
        }
    }

    public Path load(String filename) {
        return this.rootLocation.resolve(filename);
    }

    public Resource loadAsResource(String filename) {
        try {
            Path file = this.load(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new StorageFileNotFoundException("Could not read file: " + filename);
        }
        catch (MalformedURLException e) {
            throw new StorageFileNotFoundException("Could not read file: " + filename, (Throwable)e);
        }
    }

    public void deleteAll() {
        FileSystemUtils.deleteRecursively((File)this.rootLocation.toFile());
    }

    public void delete(String filename) {
        if (filename.equals("")) {
            return;
        }
        Path name = this.rootLocation.getFileName();
        try {
            Path file = this.rootLocation.resolve(filename);
            if (this.exists(file)) {
                Files.delete(file);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stored file", (Throwable)e);
        }
    }

    public boolean exists(Path file) {
        File tempFile = new File(file.toString());
        return tempFile.exists();
    }
}

