/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.security;

import com.becon.opencelium.backend.configuration.LdapProperties;
import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.service.SessionService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.database.mysql.service.TotpService;
import com.becon.opencelium.backend.database.mysql.service.UserRoleService;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.enums.AuthMethod;
import com.becon.opencelium.backend.enums.LangEnum;
import com.becon.opencelium.backend.execution.socket.Event;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationQueue;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.subs.SubsDTO;
import com.becon.opencelium.backend.resource.user.TotpResource;
import com.becon.opencelium.backend.resource.user.UserResource;
import com.becon.opencelium.backend.security.JwtTokenUtil;
import com.becon.opencelium.backend.security.UserPrincipals;
import com.becon.opencelium.backend.subscription.dto.LicenseKey;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import com.becon.opencelium.backend.utility.EmailUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Component
public class AuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @Autowired
    protected JwtTokenUtil jwtTokenUtil;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected SessionService sessionService;
    @Autowired
    protected TotpService totpService;
    @Autowired
    private LdapProperties properties;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private WebSocketNotificationQueue notificationQueue;
    @Autowired
    protected SimpMessagingTemplate messagingTemplate;
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationFilter.class);

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        super.setAuthenticationManager(authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (!request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        try {
            User user = (User)new ObjectMapper().readValue((InputStream)request.getInputStream(), User.class);
            return this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getPrincipal(), (Object)user.getPassword(), new ArrayList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication auth) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        User user = this.getUser(auth);
        if (user.getTotpSecretKey() != null) {
            TotpResource resource;
            if (user.isTotpProcessCompleted()) {
                String sessionId = user.getSession().getId();
                resource = new TotpResource(sessionId);
            } else {
                resource = this.totpService.getTotpResource(user);
            }
            String payload = mapper.writeValueAsString((Object)resource);
            response.getWriter().write(payload);
        } else {
            UserResource userResource = new UserResource(user);
            String payload = mapper.writeValueAsString((Object)userResource);
            String token = this.jwtTokenUtil.generateToken(user);
            response.getWriter().write(payload);
            response.addHeader("Authorization", "Bearer " + token);
            this.messagingTemplate.convertAndSendToUser(user.getPrincipal(), "/session", (Object)Event.of((String)"FORCE_LOGOUT", (String)"New login detected"));
            this.sendSubscriptionNotification();
        }
        response.setContentType("application/json");
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        ObjectMapper mapper = new ObjectMapper();
        ErrorResource errorResource = new ErrorResource((Exception)failed, HttpStatus.UNAUTHORIZED, uri.getPath());
        String payload = mapper.writeValueAsString((Object)errorResource);
        response.setContentType("application/json");
        response.getWriter().write(payload);
        response.setStatus(HttpStatus.FORBIDDEN.value());
    }

    protected void sendSubscriptionNotification() {
        Subscription subscription = this.subscriptionService.getActiveSubs();
        if (subscription != null) {
            String licenseKeyRaw = subscription.getLicenseKey();
            LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)licenseKeyRaw);
            SubsDTO subsDTO = this.subscriptionService.toDto(licenseKey, subscription);
            this.notificationQueue.addMessage("/subscription", (Object)subsDTO);
        }
    }

    private User getUser(Authentication authentication) {
        String authType;
        User result;
        Object principal = authentication.getPrincipal();
        if (principal instanceof LdapUserDetails) {
            String roleName;
            LdapUserDetails ldapUserDetails = (LdapUserDetails)principal;
            String username = ldapUserDetails.getUsername();
            User user = this.userService.findByUsername(username).orElseGet(() -> {
                User newUser = new User();
                if (EmailUtility.isEmail((String)username)) {
                    newUser.setEmail(username);
                }
                newUser.setUsername(username);
                newUser.setAuthMethod(AuthMethod.LDAP);
                UserDetail userDetail = new UserDetail();
                userDetail.setLang(LangEnum.EN.getCode());
                userDetail.setTutorial(Boolean.valueOf(false));
                userDetail.setUser(newUser);
                newUser.setUserDetail(userDetail);
                return newUser;
            });
            Collection authorities = ldapUserDetails.getAuthorities();
            if (authorities.isEmpty()) {
                this.logInfo("User is not a member of any group under group-search-base='" + this.properties.getGroupSearchBase() + "' with group-search-filter='" + this.properties.getGroupSearchFilter() + "'");
                roleName = this.properties.getDefaultRole();
            } else {
                List groups = this.properties.getGroups();
                roleName = authorities.stream().map(GrantedAuthority::getAuthority).filter(groupDN -> {
                    if (groups.contains(groupDN)) {
                        this.logInfo("Match found for LDAP group = '" + groupDN + "'");
                        return true;
                    }
                    this.logInfo("No match found for LDAP group = '" + groupDN + "' in OC mappings " + groups.stream().collect(Collectors.joining("; ", "[", "]")));
                    return false;
                }).map(arg_0 -> ((LdapProperties)this.properties).getRoleByGroup(arg_0)).findFirst().orElse(this.properties.getDefaultRole());
            }
            UserRole role = (UserRole)this.userRoleService.findByRole(roleName).orElseThrow(() -> new EntityNotFoundException("LDAP group mapped to role = '" + roleName + "', but it does not exists in OC system."));
            user.setUserRole(role);
            result = this.userService.save(user);
            authType = "LDAP server";
        } else {
            result = ((UserPrincipals)authentication.getPrincipal()).getUser();
            authType = "OC system";
        }
        Session session = this.sessionService.replace(result.getId());
        result.setSession(session);
        this.logInfo("User " + result.getPrincipal() + " is authenticated via " + authType);
        this.logInfo("Role '" + result.getUserRole().getName() + "' has been assigned to " + result.getPrincipal());
        return result;
    }

    private void logInfo(String message) {
        if (this.properties.isShowLogs().equals("OFF")) {
            return;
        }
        logger.info(message);
    }
}

