/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.external.polyglotservice;

import com.becon.opencelium.backend.proto.ScriptRequest;
import com.becon.opencelium.backend.proto.ScriptResult;
import com.becon.opencelium.backend.scriptengine.ex.ScriptExecutionException;
import com.becon.opencelium.backend.scriptengine.external.ExternalScriptExecutor;
import com.becon.opencelium.backend.scriptengine.external.polyglotservice.PolyglotServiceGRPCClient;
import com.becon.opencelium.backend.scriptengine.external.polyglotservice.StructConverter;
import com.google.protobuf.Value;
import org.springframework.stereotype.Component;

@Component
public class GrpcPolyglotExecutor
implements ExternalScriptExecutor<ScriptRequest> {
    private final PolyglotServiceGRPCClient grpcClient;

    public GrpcPolyglotExecutor(PolyglotServiceGRPCClient grpcClient) {
        this.grpcClient = grpcClient;
    }

    public Object execute(ScriptRequest input) {
        ScriptResult result = this.grpcClient.execute(input);
        return this.handleResult(result);
    }

    public boolean isUp() {
        return this.grpcClient.isUp();
    }

    private Object handleResult(ScriptResult result) {
        if (result.getSuccess()) {
            return StructConverter.fromValue((Value)result.getResult());
        }
        throw new ScriptExecutionException(result.getErrorCode() + "-" + result.getErrorMessage());
    }
}

