/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.engines;

import com.becon.opencelium.backend.proto.ScriptRequest;
import com.becon.opencelium.backend.scriptengine.Language;
import com.becon.opencelium.backend.scriptengine.LanguageType;
import com.becon.opencelium.backend.scriptengine.ScriptEngine;
import com.becon.opencelium.backend.scriptengine.ScriptEngineType;
import com.becon.opencelium.backend.scriptengine.ex.InvalidScriptException;
import com.becon.opencelium.backend.scriptengine.ex.ScriptExecutionException;
import com.becon.opencelium.backend.scriptengine.external.ExternalScriptExecutor;
import com.becon.opencelium.backend.scriptengine.external.polyglotservice.StructConverter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PolyglotEngine
implements ScriptEngine {
    private final ExternalScriptExecutor<ScriptRequest> polyglotExecutor;
    private LanguageType languageType;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public PolyglotEngine(ExternalScriptExecutor<ScriptRequest> polyglotExecutor) {
        this.polyglotExecutor = polyglotExecutor;
    }

    public boolean supports(Language lang) {
        return lang != null && lang.getEngine() == ScriptEngineType.POLYGOT_ENGINE;
    }

    public Object execute(String script) throws ScriptExecutionException, InvalidScriptException {
        return this.execute(script, null);
    }

    public Object execute(String script, Map<String, Object> bindings) throws ScriptExecutionException, InvalidScriptException {
        return this.polyglotExecutor.execute((Object)this.buildScriptRequest(script, bindings));
    }

    public Object execute(String script, Map<String, String> bindings, Function<String, Object> refExtractor) throws ScriptExecutionException, InvalidScriptException {
        return this.execute(script, this.extractArgs(bindings, refExtractor));
    }

    public void validate(String script) throws InvalidScriptException {
    }

    public boolean isUp() {
        return this.polyglotExecutor.isUp();
    }

    public void setLanguageType(LanguageType languageType) {
        this.languageType = languageType;
    }

    private Map<String, Object> extractArgs(Map<String, String> args, Function<String, Object> referenceExtractor) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(args.size());
        for (Map.Entry<String, String> entry : args.entrySet()) {
            Object value;
            try {
                value = referenceExtractor.apply(entry.getValue());
            }
            catch (Exception e) {
                throw new ScriptExecutionException(e.getMessage(), (Throwable)e);
            }
            if (value instanceof Map || value instanceof List) {
                try {
                    String stringVal = this.objectMapper.writeValueAsString(value).replace("__oc__attributes.", "@").replace(".__oc__value", "");
                    value = value instanceof List ? this.objectMapper.readValue(stringVal, List.class) : this.objectMapper.readValue(stringVal, Map.class);
                }
                catch (Exception e) {
                    throw new ScriptExecutionException("Serialization/Deserialization error: " + e.getMessage(), (Throwable)e);
                }
            }
            resultMap.put(entry.getKey(), value);
        }
        return resultMap;
    }

    private ScriptRequest buildScriptRequest(String script, Map<String, Object> args) {
        return ScriptRequest.newBuilder().setUuid(UUID.randomUUID().toString()).setLanguage(this.languageType.getCode()).setScript(script).setArgs(StructConverter.toStruct(args)).build();
    }
}

