/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.user;

import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import jakarta.annotation.Resource;
import java.util.Date;

@Resource
public class UserDetailResource {
    private String name;
    private String surname;
    private String userTitle;
    private String phoneNumber;
    private String department;
    private String organization;
    private String profilePicture;
    private boolean appTour;
    private String theme;
    private boolean themeSync;
    private String lang;
    private String bitbucketUser;
    private String bitbucketPassword;
    private Date requestTime;
    private final String imagePath = "./storage/files/";

    public UserDetailResource() {
    }

    public UserDetailResource(UserDetail userDetail) {
        this.name = userDetail.getName();
        this.surname = userDetail.getSurname();
        this.phoneNumber = userDetail.getPhoneNumber();
        this.department = userDetail.getDepartment();
        this.organization = userDetail.getOrganization();
        this.userTitle = userDetail.getTitle();
        this.appTour = userDetail.getTutorial();
        this.theme = userDetail.getTheme();
        this.lang = userDetail.getLang();
        this.themeSync = userDetail.isThemeSync();
        this.bitbucketUser = userDetail.getRepoUser();
        if (userDetail.getProfilePicture() != null) {
            this.profilePicture = "./storage/files/" + userDetail.getProfilePicture();
        }
        if (userDetail.getUser() != null && userDetail.getUser().getSession() != null) {
            this.requestTime = userDetail.getUser().getSession().getLastAccessed();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getUserTitle() {
        return this.userTitle;
    }

    public void setUserTitle(String userTitle) {
        this.userTitle = userTitle;
    }

    public String getProfilePicture() {
        return this.profilePicture;
    }

    public void setProfilePicture(String profilePicture) {
        this.profilePicture = profilePicture;
    }

    public boolean isAppTour() {
        return this.appTour;
    }

    public void setAppTour(boolean appTour) {
        this.appTour = appTour;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getBitbucketUser() {
        return this.bitbucketUser;
    }

    public boolean isThemeSync() {
        return this.themeSync;
    }

    public void setThemeSync(boolean themeSync) {
        this.themeSync = themeSync;
    }

    public void setBitbucketUser(String bitbucketUser) {
        this.bitbucketUser = bitbucketUser;
    }

    public String getBitbucketPassword() {
        return this.bitbucketPassword;
    }

    public void setBitbucketPassword(String bitbucketPassword) {
        this.bitbucketPassword = bitbucketPassword;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }
}

