/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.user;

import com.becon.opencelium.backend.database.mysql.entity.Component;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.annotation.Resource;
import java.util.Set;
import java.util.stream.Collectors;

@Resource
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComponentResource {
    private int componentId;
    private String name;
    private Set<String> permissions;

    public ComponentResource() {
    }

    public ComponentResource(Component component) {
        this.componentId = component.getId();
        this.name = component.getName();
    }

    public ComponentResource(Component component, int userRoleId) {
        this.componentId = component.getId();
        this.name = component.getName();
        this.permissions = component.getPermissions().stream().filter(c -> c.getUserRole().getId() == userRoleId).map(p -> p.getPermission().getName()).collect(Collectors.toSet());
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }
}

