/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.execution;

import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.resource.execution.SchemaDTO;
import com.becon.opencelium.backend.resource.execution.XmlObjectDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaDTOUtil {
    public static SchemaDTO copy(SchemaDTO schema) {
        List items;
        if (schema == null) {
            return null;
        }
        SchemaDTO result = new SchemaDTO();
        result.setType(schema.getType());
        result.setValue(schema.getValue());
        Map properties = schema.getProperties();
        if (properties != null) {
            HashMap temp = new HashMap();
            properties.forEach((s, schemaDTO) -> temp.put(s, SchemaDTOUtil.copy((SchemaDTO)schemaDTO)));
            result.setProperties(temp);
        }
        if ((items = schema.getItems()) != null) {
            List temp = items.stream().map(SchemaDTOUtil::copy).collect(Collectors.toList());
            result.setItems(temp);
        }
        XmlObjectDTO xml = XmlObjectDTO.copy((XmlObjectDTO)schema.getXml());
        result.setXml(xml);
        return result;
    }

    public static SchemaDTO fromObject(Object value) {
        if (value == null) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(value);
            return SchemaDTOUtil.fromJSONNode((JsonNode)mapper.readTree(jsonString));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Supplied Object could not be converted to SchemaDTO", e);
        }
    }

    public static String toJSON(SchemaDTO schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getType() == null) {
            throw new RuntimeException("Data type must be supplied to SchemaDTO");
        }
        DataType type = schema.getType();
        if (type == DataType.OBJECT) {
            Map properties = schema.getProperties();
            if (properties == null) {
                return null;
            }
            String object = properties.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\": " + SchemaDTOUtil.toJSON((SchemaDTO)((SchemaDTO)entry.getValue()))).collect(Collectors.joining(", "));
            return "{" + object + "}";
        }
        if (type == DataType.ARRAY) {
            List items = schema.getItems();
            if (items == null) {
                return null;
            }
            String array = items.stream().map(SchemaDTOUtil::toJSON).collect(Collectors.joining(", "));
            return "[" + array + "]";
        }
        String value = schema.getValue();
        if (value == null) {
            return null;
        }
        return type == DataType.STRING ? "\"" + value + "\"" : value;
    }

    public static String toText(SchemaDTO schema) {
        if (schema == null) {
            return null;
        }
        return schema.getValue();
    }

    public static String toXML(SchemaDTO schema) {
        if (schema == null) {
            return null;
        }
        DataType type = schema.getType();
        if (type == null) {
            throw new RuntimeException("DataType must be supplied to SchemaDTO");
        }
        if (type != DataType.OBJECT || schema.getProperties() == null || schema.getProperties().size() != 1) {
            throw new RuntimeException("Couldn't find root element");
        }
        StringBuilder result = new StringBuilder();
        schema.getProperties().forEach((name, value) -> SchemaDTOUtil.writeTag((StringBuilder)result, (String)name, (SchemaDTO)value));
        return result.toString();
    }

    private static void writeTag(StringBuilder collector, String name, SchemaDTO value) {
        String tagName = SchemaDTOUtil.getName((String)name, (SchemaDTO)value);
        String attributes = SchemaDTOUtil.getAttributes((SchemaDTO)value);
        String tagValue = SchemaDTOUtil.getValue((String)name, (SchemaDTO)value);
        if (value != null && value.getType() == DataType.ARRAY) {
            if (value.getXml() != null && value.getXml().isWrapped()) {
                collector.append("<").append(tagName).append(attributes).append(">").append(tagValue).append("</").append(tagName).append(">");
            } else {
                collector.append(tagValue);
            }
        } else {
            collector.append("<").append(tagName).append(attributes).append(">").append(tagValue).append("</").append(tagName).append(">");
        }
    }

    private static String getName(String name, SchemaDTO value) {
        Object result = name;
        if (value == null || value.getXml() == null) {
            return result;
        }
        XmlObjectDTO xml = value.getXml();
        if (xml.getName() != null) {
            result = xml.getName();
        }
        if (xml.getPrefix() != null) {
            result = xml.getPrefix() + ":" + (String)result;
        }
        return result;
    }

    private static String getAttributes(SchemaDTO schema) {
        String prefix;
        if (schema == null) {
            return "";
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add("");
        XmlObjectDTO xml = schema.getXml();
        if (xml != null && xml.getNamespace() != null) {
            prefix = xml.getPrefix() == null ? "" : ":" + xml.getPrefix();
            attributes.add("xmlns" + prefix + "=\"" + xml.getNamespace() + "\"");
        }
        if (schema.getProperties() != null) {
            prefix = xml == null || xml.getPrefix() == null ? "" : xml.getPrefix() + ":";
            schema.getProperties().forEach((name, value) -> {
                if (value.getXml() != null && value.getXml().isAttribute()) {
                    String attributeName = SchemaDTOUtil.getName((String)name, (SchemaDTO)value);
                    attributes.add(prefix + attributeName + "=\"" + value.getValue() + "\"");
                }
            });
        }
        return String.join((CharSequence)" ", attributes);
    }

    private static String getValue(String name, SchemaDTO value) {
        if (value == null) {
            return "";
        }
        DataType type = value.getType();
        if (type.isPrimitive()) {
            return value.getValue() == null ? "" : value.getValue();
        }
        if (type == DataType.ARRAY) {
            if (value.getItems() == null) {
                return "";
            }
            String arrayName = SchemaDTOUtil.getName((String)name, (SchemaDTO)value);
            StringBuilder array = new StringBuilder();
            for (SchemaDTO item : value.getItems()) {
                SchemaDTOUtil.writeTag((StringBuilder)array, (String)arrayName, (SchemaDTO)item);
            }
            return array.toString();
        }
        if (value.getProperties() == null) {
            return "";
        }
        StringBuilder object = new StringBuilder();
        value.getProperties().forEach((propertyName, propertyValue) -> {
            if (propertyValue.getXml() == null || !propertyValue.getXml().isAttribute()) {
                SchemaDTOUtil.writeTag((StringBuilder)object, (String)propertyName, (SchemaDTO)propertyValue);
            }
        });
        return object.toString();
    }

    private static SchemaDTO fromJSONNode(JsonNode jsonNode) {
        JsonNodeType nodeType = jsonNode.getNodeType();
        SchemaDTO result = new SchemaDTO();
        if (nodeType == JsonNodeType.OBJECT) {
            result.setType(DataType.OBJECT);
            HashMap<String, SchemaDTO> properties = new HashMap<String, SchemaDTO>();
            Iterator fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                properties.put((String)field.getKey(), SchemaDTOUtil.fromJSONNode((JsonNode)((JsonNode)field.getValue())));
            }
            result.setProperties(properties);
        } else if (nodeType == JsonNodeType.ARRAY) {
            result.setType(DataType.ARRAY);
            ArrayList<SchemaDTO> items = new ArrayList<SchemaDTO>();
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                items.add(SchemaDTOUtil.fromJSONNode((JsonNode)element));
            }
            result.setItems(items);
        } else if (nodeType == JsonNodeType.BOOLEAN) {
            result.setType(DataType.BOOLEAN);
            result.setValue(jsonNode.asText());
        } else if (nodeType == JsonNodeType.STRING) {
            result.setType(DataType.STRING);
            result.setValue(jsonNode.asText());
        } else if (nodeType == JsonNodeType.NUMBER) {
            String value = jsonNode.asText();
            if (value.contains(".")) {
                result.setType(DataType.NUMBER);
            } else {
                result.setType(DataType.INTEGER);
            }
            result.setValue(value);
        } else {
            result = null;
        }
        return result;
    }
}

