/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.quartz;

import com.becon.opencelium.backend.database.mysql.entity.MaskingRule;
import com.becon.opencelium.backend.exception.ConnectionNotFoundException;
import com.becon.opencelium.backend.exception.SchedulerNotFoundException;
import com.becon.opencelium.backend.quartz.JobExecutor;
import com.becon.opencelium.backend.quartz.QuartzJobScheduler;
import com.becon.opencelium.backend.quartz.SchedulingStrategy;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class QuartzJobScheduler
implements SchedulingStrategy {
    private final Scheduler quartzScheduler;

    public QuartzJobScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void addJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        try {
            String jobName = this.getJobName(scheduler);
            JobKey jobKey = new JobKey(jobName, "connection");
            if (scheduler.getCronExp() == null || scheduler.getCronExp().isBlank()) {
                scheduler.setCronExp("59 59 23 31 12 ? 2123");
            } else {
                this.validateCron(scheduler.getCronExp());
            }
            if (this.quartzScheduler.checkExists(jobKey)) {
                throw new RuntimeException("JOB_ALREADY_EXISTS");
            }
            TriggerKey triggerKey = this.getTriggerKey(scheduler, false);
            ScheduleData data = new ScheduleData(scheduler.getId(), TriggerType.SCHEDULER);
            1 jobDataMap = new /* Unavailable Anonymous Inner Class!! */;
            JobDetail jobDetail = JobBuilder.newJob(JobExecutor.class).withIdentity(jobKey).usingJobData((JobDataMap)jobDataMap).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)scheduler.getCronExp())).forJob(jobKey).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        try {
            boolean deleted = this.quartzScheduler.deleteJob(jobKey);
            if (!deleted) {
                System.err.println("JOB_NOT_FOUND");
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void rescheduleJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler updated, Long oldCon) {
        if (!updated.getConnection().getId().equals(oldCon)) {
            this.deleteJob((com.becon.opencelium.backend.database.mysql.entity.Scheduler)new /* Unavailable Anonymous Inner Class!! */);
            this.addJob(updated);
            return;
        }
        String jobName = this.getJobName(updated);
        JobKey jobKey = new JobKey(jobName, "connection");
        if (updated.getCronExp() == null || updated.getCronExp().isBlank()) {
            updated.setCronExp("59 59 23 31 12 ? 2123");
        } else {
            this.validateCron(updated.getCronExp());
        }
        try {
            Trigger currTrigger = this.quartzScheduler.getTrigger(this.getTriggerKey(updated, false));
            if (currTrigger == null) {
                throw new RuntimeException("JOB_NOT_FOUND");
            }
            CronTrigger newTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(currTrigger.getKey()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)updated.getCronExp())).forJob(jobKey).build();
            this.quartzScheduler.rescheduleJob(currTrigger.getKey(), (Trigger)newTrigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void runJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        TriggerKey triggerKey = this.getTriggerKey(scheduler, true);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(triggerKey).startNow().build();
        try {
            boolean isPresent = this.quartzScheduler.checkExists(jobKey);
            if (isPresent) {
                this.quartzScheduler.scheduleJob(trigger);
            } else {
                ScheduleData data = new ScheduleData(scheduler.getId(), TriggerType.SCHEDULER);
                3 jobDataMap = new /* Unavailable Anonymous Inner Class!! */;
                JobDetail jobDetail = JobBuilder.newJob(JobExecutor.class).withIdentity(jobKey).usingJobData((JobDataMap)jobDataMap).build();
                this.quartzScheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (JobPersistenceException e) {
            this.retry(scheduler, 1);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void runJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, String channelId) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        ScheduleData data = new ScheduleData(scheduler.getId(), TriggerType.EXECUTION_TEST);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("data", (Object)data);
        TriggerKey triggerKey = this.getTriggerKey(scheduler, true);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(triggerKey).usingJobData(jobDataMap).startNow().build();
        try {
            this.quartzScheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error scheduling job", e);
        }
    }

    public void runJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, Map<String, Object> webhookVars) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        ScheduleData data = new ScheduleData(scheduler.getId(), TriggerType.WEBHOOK, webhookVars);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("data", (Object)data);
        TriggerKey triggerKey = this.getTriggerKey(scheduler, true);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(triggerKey).usingJobData(jobDataMap).startNow().build();
        try {
            this.quartzScheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error scheduling job", e);
        }
    }

    public void runJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, List<MaskingRule> rules) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        ScheduleData data = new ScheduleData(scheduler.getId(), TriggerType.SUPPORT_FILE, rules);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("data", (Object)data);
        TriggerKey triggerKey = this.getTriggerKey(scheduler, true);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(triggerKey).usingJobData(jobDataMap).startNow().build();
        try {
            this.quartzScheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error scheduling job", e);
        }
    }

    public void resumeJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        try {
            if (!this.quartzScheduler.checkExists(jobKey)) {
                throw new RuntimeException("JOB_NOT_FOUND");
            }
            this.quartzScheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void pauseJob(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        try {
            if (!this.quartzScheduler.checkExists(jobKey)) {
                throw new RuntimeException("JOB_NOT_FOUND");
            }
            this.quartzScheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Long, Integer> getRunningJobs() {
        try {
            return this.quartzScheduler.getCurrentlyExecutingJobs().stream().map(JobExecutionContext::getJobDetail).map(JobDetail::getKey).filter(k -> k.getName().split("-")[0].matches("-?\\d+(\\.\\d+)?") && k.getName().split("-")[1].matches("-?\\d+(\\.\\d+)?")).collect(Collectors.toMap(e -> Long.valueOf(e.getName().split("-")[0]), e -> Integer.parseInt(e.getName().split("-")[1])));
        }
        catch (SchedulerException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void validateCron(String cron) {
        try {
            new CronExpression(cron);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void terminate(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        String jobName = this.getJobName(scheduler);
        JobKey jobKey = new JobKey(jobName, "connection");
        try {
            if (!this.quartzScheduler.checkExists(jobKey)) {
                return;
            }
            this.quartzScheduler.interrupt(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private String getJobName(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        if (scheduler == null || scheduler.getId() == 0) {
            throw new SchedulerNotFoundException(0);
        }
        if (scheduler.getConnection() == null || scheduler.getConnection().getId() == null) {
            throw new ConnectionNotFoundException(Long.valueOf(0L));
        }
        return scheduler.getConnection().getId() + "-" + scheduler.getId();
    }

    private TriggerKey getTriggerKey(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, boolean fireOnce) {
        String name = (String)(fireOnce ? "FIRES_ONCE-" + System.currentTimeMillis() + "-" : "") + scheduler.getId();
        return new TriggerKey(name, Long.toString(scheduler.getConnection().getId()));
    }

    private void retry(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, int times) {
        if (times == 0) {
            return;
        }
        try {
            this.deleteJob(scheduler);
            this.addJob(scheduler);
            this.runJob(scheduler);
        }
        catch (Exception e) {
            this.retry(scheduler, times - 1);
        }
    }
}

