/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.token;

import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.ocel.function.FunctionEnum;
import com.becon.opencelium.backend.ocel.function.FunctionUtils;
import com.becon.opencelium.backend.ocel.operand.OperandUtils;
import com.becon.opencelium.backend.ocel.operator.OperatorEnum;
import com.becon.opencelium.backend.ocel.operator.OperatorUtils;
import com.becon.opencelium.backend.ocel.token.Token;
import com.becon.opencelium.backend.ocel.token.TokenType;
import com.becon.opencelium.backend.ocel.utils.ReferenceUtils;
import com.becon.opencelium.backend.ocel.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class Tokenizer {
    private static final Map<String, String> prefixSuffixMap = new HashMap();

    private Tokenizer() {
    }

    public static List<Token> splitTokens(String expression) throws InvalidExpressionException {
        char[] chars = expression.toCharArray();
        ArrayList<Token> res = new ArrayList<Token>();
        String prefix = null;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (prefix == null && chars[i] == ' ') {
                if (i != start && i > 0 && chars[i - 1] != ')') {
                    res.add(Token.of((String)expression.substring(start, i), (TokenType)TokenType.OPERAND));
                }
                start = i + 1;
                continue;
            }
            if (prefix == null && chars[i] == '(') {
                if (start != i && i > 0 && chars[i - 1] != '(') {
                    res.add(Token.of((String)expression.substring(start, i), (TokenType)TokenType.OPERAND));
                }
                res.add(Token.openBrace());
                start = i + 1;
                continue;
            }
            if (prefix == null && chars[i] == ')') {
                if (start != i && i > 0 && chars[i - 1] != ')') {
                    res.add(Token.of((String)expression.substring(start, i), (TokenType)TokenType.OPERAND));
                }
                res.add(Token.closeBrace());
                start = i + 1;
                continue;
            }
            if (prefix == null) {
                FunctionEnum function;
                OperatorEnum operatorEnum;
                boolean done = false;
                String newPre = Tokenizer.tryToFindPrefix((char[])chars, (int)i);
                if (newPre != null) {
                    prefix = newPre;
                    i += newPre.length() - 1;
                    done = true;
                }
                if (!done && (operatorEnum = OperatorUtils.findStartingOperator((char[])chars, (int)i)) != null) {
                    String op = operatorEnum.getName();
                    int len = op.length();
                    if (start != i) {
                        res.add(Token.of((String)expression.substring(start, i), (TokenType)TokenType.OPERAND));
                    }
                    res.add(Token.of((String)op, (TokenType)TokenType.OPERATOR));
                    start = i + len;
                    i += len - 1;
                    done = true;
                }
                if (!done && (function = FunctionUtils.findStartingFunction((char[])chars, (int)i)) != null) {
                    int end = Tokenizer.indexOfFirstOutermostClosingParentheses((char[])chars, (int)i);
                    if (end == -1) {
                        throw InvalidExpressionException.unexpectedEndOfExpression((String)expression.substring(i));
                    }
                    if (start != i) {
                        res.add(Token.of((String)expression.substring(start, i), (TokenType)TokenType.OPERAND));
                    }
                    List expressions = Tokenizer.splitParametersOfFunction((char[])chars, (int)(i + function.getName().length() + 1), (int)end);
                    ArrayList<List> parameters = new ArrayList<List>();
                    for (String token : expressions) {
                        List tokenizedParam = Tokenizer.splitTokens((String)token);
                        parameters.add(tokenizedParam);
                    }
                    res.add(Token.of((String)function.getName(), (TokenType)TokenType.FUNCTION, parameters));
                    start = end + 1;
                    i = end;
                }
            } else {
                String suffix = Tokenizer.tryToFindSuffix((char[])chars, (int)i, prefix);
                if (suffix != null) {
                    prefix = null;
                    i += suffix.length() - 1;
                } else if (i >= chars.length - 1) {
                    throw InvalidExpressionException.unexpectedEndOfExpression((String)expression.substring(start));
                }
            }
            if (i < chars.length - 1 || start > chars.length - 1) continue;
            res.add(Token.of((String)expression.substring(start), (TokenType)TokenType.OPERAND));
        }
        return res;
    }

    private static List<String> splitParametersOfFunction(char[] chars, int start, int end) throws InvalidExpressionException {
        ArrayList<String> res = new ArrayList<String>();
        String prefix = null;
        int left = start;
        int depth = 0;
        for (int i = start; i < end; ++i) {
            if (prefix == null && depth == 0 && chars[i] == ',') {
                res.add(new String(chars, left, i - left));
                left = i + 1;
                continue;
            }
            if (prefix == null && chars[i] == '(') {
                ++depth;
                continue;
            }
            if (prefix == null && chars[i] == ')') {
                if (--depth >= 0) continue;
                throw InvalidExpressionException.invalidParentheses();
            }
            if (prefix == null) {
                String newPrefix = Tokenizer.tryToFindPrefix((char[])chars, (int)i);
                if (newPrefix != null) {
                    prefix = newPrefix;
                    i += prefix.length() - 1;
                    continue;
                }
                if (i < end - 1) continue;
                throw InvalidExpressionException.unexpectedEndOfExpression((String)new String(chars, start, end));
            }
            String suffix = Tokenizer.tryToFindSuffix((char[])chars, (int)i, prefix);
            if (suffix != null) {
                prefix = null;
                i += suffix.length() - 1;
            }
            if (i < end - 1 || left == end - 1) continue;
            res.add(new String(chars, left, end - left));
        }
        return res;
    }

    private static int indexOfFirstOutermostClosingParentheses(char[] chars, int startIndex) {
        int depth = 0;
        boolean started = false;
        String prefix = null;
        for (int i = startIndex; i < chars.length; ++i) {
            if (prefix == null && chars[i] == '(') {
                ++depth;
                started = true;
                continue;
            }
            if (prefix == null && chars[i] == ')') {
                if (!started || --depth != 0) continue;
                return i;
            }
            if (prefix == null) {
                String newPrefix = Tokenizer.tryToFindPrefix((char[])chars, (int)i);
                if (newPrefix == null) continue;
                prefix = newPrefix;
                i += prefix.length() - 1;
                continue;
            }
            String suffix = Tokenizer.tryToFindSuffix((char[])chars, (int)i, prefix);
            if (suffix == null) continue;
            prefix = null;
            i += suffix.length() - 1;
        }
        return -1;
    }

    public static boolean isValidToken(String token) {
        return ")".equals(token) || "(".equals(token) || OperandUtils.isOperand((String)token) || OperatorUtils.isOperator((String)token) || FunctionUtils.isFunction((String)token);
    }

    private static String tryToFindPrefix(char[] chars, int index) {
        for (Map.Entry entry : prefixSuffixMap.entrySet()) {
            String pre = (String)entry.getKey();
            if (!Utils.startsWith((String)pre, (char[])chars, (int)index)) continue;
            return pre;
        }
        return null;
    }

    private static String tryToFindSuffix(char[] chars, int index, String prefix) {
        String suffix = (String)prefixSuffixMap.get(prefix);
        return Utils.startsWith((String)suffix, (char[])chars, (int)index) ? suffix : null;
    }

    static {
        prefixSuffixMap.putAll(ReferenceUtils.getPreSufMap());
        prefixSuffixMap.put("\"", "\"");
        prefixSuffixMap.put("'", "'");
        prefixSuffixMap.put("[", "]");
    }
}

