/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.postfix;

import com.becon.opencelium.backend.execution.logger.OcLogger;
import com.becon.opencelium.backend.execution.logger.msg.ExecutionLog;
import com.becon.opencelium.backend.execution.masking.MaskingService;
import com.becon.opencelium.backend.ocel.Evaluator;
import com.becon.opencelium.backend.ocel.ast.ASTNode;
import com.becon.opencelium.backend.ocel.ast.BinaryOpNode;
import com.becon.opencelium.backend.ocel.ast.UnaryOpNode;
import com.becon.opencelium.backend.ocel.ast.ValueNode;
import com.becon.opencelium.backend.ocel.exception.ApplyFunctionException;
import com.becon.opencelium.backend.ocel.exception.ApplyOperatorException;
import com.becon.opencelium.backend.ocel.exception.ExceptionWrapper;
import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.ocel.exception.ValueParseException;
import com.becon.opencelium.backend.ocel.function.Function;
import com.becon.opencelium.backend.ocel.function.FunctionFactory;
import com.becon.opencelium.backend.ocel.operator.Arity;
import com.becon.opencelium.backend.ocel.operator.Operator;
import com.becon.opencelium.backend.ocel.operator.OperatorUtils;
import com.becon.opencelium.backend.ocel.postfix.PostfixNotationConvertor;
import com.becon.opencelium.backend.ocel.token.Token;
import com.becon.opencelium.backend.ocel.token.TokenType;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;

public class PostfixEvaluator
implements Evaluator {
    private static final PostfixEvaluator INSTANCE = new PostfixEvaluator();
    private final PostfixNotationConvertor postfixConverter = PostfixNotationConvertor.getInstance();

    private PostfixEvaluator() {
    }

    public Object evaluate(List<Token> tokens, java.util.function.Function<String, Object> referenceExtractor) throws InvalidExpressionException {
        return this.evaluate(tokens, referenceExtractor, null, null);
    }

    public Object evaluate(List<Token> tokens, java.util.function.Function<String, Object> referenceExtractor, OcLogger<ExecutionLog> logger, MaskingService masking) {
        try {
            Queue tokenQueue = this.postfixConverter.toPostfix(tokens);
            Stack<Object> nodeStack = new Stack<Object>();
            while (!tokenQueue.isEmpty()) {
                Token token = (Token)tokenQueue.poll();
                if (token.getType() == TokenType.OPERATOR) {
                    Operator operator = OperatorUtils.getOperator((String)token.getLexeme());
                    Arity arity = operator.getArity();
                    if (arity == Arity.UNARY) {
                        ASTNode operandNode = (ASTNode)nodeStack.pop();
                        nodeStack.push(new UnaryOpNode(operator, operandNode));
                        continue;
                    }
                    if (arity != Arity.BINARY) continue;
                    ASTNode rightNode = (ASTNode)nodeStack.pop();
                    ASTNode leftNode = (ASTNode)nodeStack.pop();
                    nodeStack.push(new BinaryOpNode(operator, leftNode, rightNode));
                    continue;
                }
                if (token.getType() == TokenType.OPERAND) {
                    nodeStack.push(new ValueNode(token.getLexeme()));
                    continue;
                }
                if (token.getType() != TokenType.FUNCTION) continue;
                List parameters = token.getFunctionParameters();
                String lexeme = token.getLexeme();
                Object[] parameterValues = new Object[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    List parameter = (List)parameters.get(i);
                    parameterValues[i] = this.evaluate(parameter, referenceExtractor, logger, masking);
                }
                Function function = FunctionFactory.function((String)lexeme, (Object[])parameterValues);
                if (Objects.isNull(function)) {
                    throw InvalidExpressionException.functionNotFound((String)lexeme, (Object[])parameterValues);
                }
                try {
                    nodeStack.add(new ValueNode(function.call(parameterValues)));
                }
                catch (ApplyFunctionException e) {
                    throw InvalidExpressionException.applyFunctionException((ApplyFunctionException)e);
                }
            }
            if (nodeStack.size() != 1) {
                throw InvalidExpressionException.invalidAssociationBetweenOperatorAndOperands();
            }
            ASTNode rootNode = (ASTNode)nodeStack.pop();
            try {
                return rootNode.eval(referenceExtractor, logger, masking);
            }
            catch (InvalidExpressionException e) {
                throw new RuntimeException(e);
            }
            catch (ApplyOperatorException e) {
                throw InvalidExpressionException.applyOperatorException((ApplyOperatorException)e);
            }
            catch (ValueParseException e) {
                throw InvalidExpressionException.valueParseException((ValueParseException)e);
            }
            catch (ExceptionWrapper e) {
                if (e.getOriginalException() instanceof InvalidExpressionException) {
                    throw e;
                }
                Exception exception = e.getOriginalException();
                if (exception instanceof ValueParseException) {
                    ValueParseException vpe = (ValueParseException)((Object)exception);
                    throw InvalidExpressionException.valueParseException((ValueParseException)vpe);
                }
                exception = e.getOriginalException();
                if (exception instanceof ApplyOperatorException) {
                    ApplyOperatorException aoe = (ApplyOperatorException)((Object)exception);
                    throw InvalidExpressionException.applyOperatorException((ApplyOperatorException)aoe);
                }
                throw e.getOriginalException();
            }
        }
        catch (Exception e) {
            throw InvalidExpressionException.unexpectedException((Exception)e);
        }
    }

    public static PostfixEvaluator getInstance() {
        return INSTANCE;
    }
}

