/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.operator.operators;

import com.becon.opencelium.backend.ocel.exception.ApplyOperatorException;
import com.becon.opencelium.backend.ocel.operator.BinaryOperator;
import com.becon.opencelium.backend.ocel.operator.OperatorEnum;
import com.becon.opencelium.backend.ocel.operator.SidesType;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyExists
implements BinaryOperator {
    public Object apply(Object o1, Object o2) throws ApplyOperatorException {
        if (o1 instanceof Set) {
            Set set = (Set)o1;
            return set.contains(o2);
        }
        if (o1 instanceof List) {
            List list = (List)o1;
            return list.contains(o2);
        }
        if (o1 instanceof Map) {
            Map object = (Map)o1;
            return object.containsKey(o2);
        }
        throw ApplyOperatorException.invalidTypePairsException((OperatorEnum)this.getOperatorType(), (Object)o1, (Object)o2);
    }

    public OperatorEnum getOperatorType() {
        return OperatorEnum.PROPERTY_EXISTS;
    }

    public boolean isValidOperand(SidesType side, Object operand) {
        if (side == SidesType.LEFT) {
            return operand instanceof List || operand instanceof Map || operand instanceof Set;
        }
        return true;
    }

    public boolean isValidType(SidesType side, Class<?> type) {
        if (side == SidesType.LEFT) {
            return type.equals(List.class) || type.equals(Map.class) || type.equals(Set.class);
        }
        return true;
    }
}

