/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.exception;

import com.becon.opencelium.backend.ocel.exception.ErrorCode;

public class ValueParseException
extends Exception {
    private final ErrorCode code;
    private final String message;

    public ValueParseException(ErrorCode code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ValueParseException invalidElementOfArray(String element) {
        return new ValueParseException(ErrorCode.VP_INVALID_ELEMENT_OF_ARRAY, "Invalid element of an array : " + element);
    }

    public static ValueParseException unknownOperandValue(String val) {
        return new ValueParseException(ErrorCode.INVALID_TOKEN_FOUND, "Unknown operand : " + val);
    }

    public static ValueParseException mismatchElementTypeOfArray(String element, Class<?> elementType) {
        return new ValueParseException(ErrorCode.VP_MISMATCH_ELEMENT_TYPE_OF_ARRAY, "An element's type is not matched with previous element(s) type. Expected type -'%s', Element - '%s'".formatted(elementType.getSimpleName(), element));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getCodeString() {
        return this.code.getCode();
    }

    public ErrorCode getCode() {
        return this.code;
    }
}

