/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.exception;

import com.becon.opencelium.backend.ocel.exception.ApplyOperatorException;
import com.becon.opencelium.backend.ocel.exception.ErrorCode;
import com.becon.opencelium.backend.ocel.operator.Arity;
import com.becon.opencelium.backend.ocel.operator.OperatorEnum;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplyOperatorException
extends Exception {
    private final ErrorCode code;
    private final OperatorEnum operator;
    private final Object o1;
    private final Object o2;
    private final Arity arity;

    public ApplyOperatorException(ErrorCode code, OperatorEnum operator, Object o1, Object o2) {
        this(code, operator, o1, o2, Arity.BINARY);
    }

    public ApplyOperatorException(ErrorCode code, OperatorEnum operator, Object o1, Object o2, Arity arity) {
        this.code = code;
        this.operator = operator;
        this.o1 = o1;
        this.o2 = o2;
        this.arity = arity;
    }

    public static ApplyOperatorException invalidTypePairsException(OperatorEnum operator, Object o1, Object o2) {
        return new ApplyOperatorException(ErrorCode.AO_INVALID_OPERAND_PAIRS, operator, o1, o2);
    }

    public static ApplyOperatorException invalidTypeException(OperatorEnum operator, Object o) {
        return new ApplyOperatorException(ErrorCode.AO_INVALID_TYPE, operator, o, null, Arity.UNARY);
    }

    public static ApplyOperatorException invalidOperandValueException(OperatorEnum operator, Object o1, Object o2) {
        return ApplyOperatorException.invalidOperandValueException((OperatorEnum)operator, (Object)o1, (Object)o2, (Arity)Arity.BINARY);
    }

    public static ApplyOperatorException invalidOperandValueException(OperatorEnum operator, Object o1, Object o2, Arity arity) {
        return new ApplyOperatorException(ErrorCode.AO_INVALID_OPERAND_VALUE, operator, o1, o2, arity);
    }

    public static ApplyOperatorException invalidOperandValueException(OperatorEnum operator, Object o) {
        return new ApplyOperatorException(ErrorCode.AO_INVALID_OPERAND_VALUE, operator, o, null);
    }

    @Override
    public String getMessage() {
        return switch (1.$SwitchMap$com$becon$opencelium$backend$ocel$exception$ErrorCode[this.code.ordinal()]) {
            case 1 -> "'%s' operator doesn't support these pairs. 1-operand '%s', 2-operand '%s'".formatted(this.operator.getName(), this.o1, this.o2);
            case 2 -> {
                if (this.arity == Arity.UNARY || this.arity == null) {
                    yield "'%s' operator doesn't support this value - '%s'".formatted(this.operator, this.o1);
                }
                yield "'%s' operator doesn't support these value pairs. 1-value - '%s', 2-value - '%s'".formatted(this.operator, this.o1, this.o2);
            }
            case 3 -> "'%s' operator doesn't support this operand: '%s'".formatted(this.operator, this.o1);
            default -> this.getMessage();
        };
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public Object getO1() {
        return this.o1;
    }

    public Object getO2() {
        return this.o2;
    }

    public String getCodeString() {
        return this.code.getCode();
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public Arity getArity() {
        return this.arity;
    }
}

