/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.ast;

import com.becon.opencelium.backend.execution.logger.OcLogger;
import com.becon.opencelium.backend.execution.logger.msg.ExecutionLog;
import com.becon.opencelium.backend.execution.masking.MaskingService;
import com.becon.opencelium.backend.ocel.ast.ASTNode;
import com.becon.opencelium.backend.ocel.common.RawValueParser;
import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.ocel.exception.ValueParseException;
import com.becon.opencelium.backend.ocel.utils.ReferenceUtils;
import com.becon.opencelium.backend.ocel.utils.ValueUtils;
import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import java.util.List;
import java.util.function.Function;

public class ValueNode
implements ASTNode {
    private final String value;
    private final Object readyValue;
    private final boolean ready;
    private static final RawValueParser valueParser = RawValueParser.getInstance();

    public ValueNode(String value) {
        this.value = value;
        this.ready = false;
        this.readyValue = null;
    }

    public ValueNode(Object value) {
        this.readyValue = value;
        this.ready = true;
        this.value = null;
    }

    public Object eval(Function<String, Object> refExtractor, OcLogger<ExecutionLog> logger, MaskingService masking) throws ValueParseException {
        if (this.ready) {
            return this.readyValue;
        }
        return this.getValueOfRaw(this.value, refExtractor, logger, masking);
    }

    private Object getValueOfRaw(String rawValue, Function<String, Object> referenceExtractor, OcLogger<ExecutionLog> logger, MaskingService masking) throws ValueParseException, InvalidExpressionException {
        if (ReferenceUtils.isReference((String)rawValue)) {
            if (referenceExtractor == null) {
                throw InvalidExpressionException.referenceExtractorNotFound((String)rawValue);
            }
            Object result = referenceExtractor.apply(rawValue);
            this.logResult(result, rawValue, logger, masking);
            return result;
        }
        List locs = PathAndReferenceUtility.extractReferenceIndexes((String)rawValue);
        if (locs.isEmpty()) {
            return valueParser.parse(rawValue);
        }
        if (referenceExtractor == null) {
            throw InvalidExpressionException.referenceExtractorNotFound((String)rawValue);
        }
        StringBuilder out = new StringBuilder(rawValue.length());
        int pos = 0;
        for (int[] loc : locs) {
            int start = loc[0];
            int end = loc[1];
            out.append(rawValue, pos, start);
            String ref = rawValue.substring(start, end);
            Object result = referenceExtractor.apply(ref);
            this.logResult(result, ref, logger, masking);
            String stringResult = ValueUtils.serializeValue((Object)result);
            out.append(stringResult);
            pos = end;
        }
        out.append(rawValue, pos, rawValue.length());
        if (out.charAt(0) == '\"' && out.charAt(out.length() - 1) == '\"') {
            out.deleteCharAt(0);
            out.deleteCharAt(out.length() - 1);
        }
        return out.toString();
    }

    private void logResult(Object result, String ref, OcLogger<ExecutionLog> logger, MaskingService masking) {
        if (logger != null && masking != null) {
            String maskedResult = masking.applyMask(result, ref);
            logger.logAndSend("segment=IF_REF ref=(%s) data=%s".formatted(ref, maskedResult));
        }
    }
}

