/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.mysql;

import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.mapper.mysql.ConnectorMapper;
import com.becon.opencelium.backend.mapper.utils.HelperMapper;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connector.InvokerDTO;
import com.becon.opencelium.backend.utility.StringUtility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectorMapperImpl
implements ConnectorMapper {
    @Autowired
    private HelperMapper helperMapper;

    public Connector toEntity(ConnectorDTO dto) {
        if (dto == null) {
            return null;
        }
        Connector connector = new Connector();
        if (dto.getConnectorId() != null) {
            connector.setId(dto.getConnectorId().intValue());
        }
        connector.setInvoker(this.dtoInvokerName(dto));
        connector.setSslValidation(dto.isSslCert());
        connector.setTitle(dto.getTitle());
        connector.setTimeout(dto.getTimeout());
        connector.setIcon(StringUtility.findImageFromUrl((String)dto.getIcon()));
        return connector;
    }

    public ConnectorDTO toDTO(Connector entity) {
        if (entity == null) {
            return null;
        }
        ConnectorDTO connectorDTO = new ConnectorDTO();
        connectorDTO.setConnectorId(Integer.valueOf(entity.getId()));
        connectorDTO.setInvoker(this.helperMapper.getInvokerDTO(entity.getInvoker()));
        connectorDTO.setSslCert(entity.isSslValidation());
        connectorDTO.setTitle(entity.getTitle());
        connectorDTO.setTimeout(entity.getTimeout());
        connectorDTO.setIcon(StringUtility.resolveImagePath((String)entity.getIcon()));
        return connectorDTO;
    }

    private String dtoInvokerName(ConnectorDTO connectorDTO) {
        if (connectorDTO == null) {
            return null;
        }
        InvokerDTO invoker = connectorDTO.getInvoker();
        if (invoker == null) {
            return null;
        }
        String name = invoker.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

