/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.mysql;

import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.mapper.mysql.ConnectionResourceMapper;
import com.becon.opencelium.backend.mapper.utils.HelperMapper;
import com.becon.opencelium.backend.resource.connection.ConnectionResource;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.utility.StringUtility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionResourceMapperImpl
implements ConnectionResourceMapper {
    @Autowired
    private HelperMapper helperMapper;

    public Connection toEntity(ConnectionResource dto) {
        if (dto == null) {
            return null;
        }
        Connection connection = new Connection();
        connection.setFromConnector(this.dtoFromConnectorConnectorId(dto));
        connection.setToConnector(this.dtoToConnectorConnectorId(dto));
        connection.setId(dto.getId());
        connection.setTitle(dto.getTitle());
        connection.setDescription(dto.getDescription());
        connection.setCategoryId(dto.getCategoryId());
        connection.setIcon(StringUtility.findImageFromUrl((String)dto.getIcon()));
        return connection;
    }

    public ConnectionResource toDTO(Connection entity) {
        if (entity == null) {
            return null;
        }
        ConnectionResource connectionResource = new ConnectionResource();
        connectionResource.setFromConnector(this.helperMapper.getConnectorResourceById(entity.getFromConnector()));
        connectionResource.setToConnector(this.helperMapper.getConnectorResourceById(entity.getToConnector()));
        connectionResource.setId(entity.getId());
        connectionResource.setTitle(entity.getTitle());
        connectionResource.setDescription(entity.getDescription());
        connectionResource.setCategoryId(entity.getCategoryId());
        connectionResource.setIcon(StringUtility.resolveImagePath((String)entity.getIcon()));
        return connectionResource;
    }

    private int dtoFromConnectorConnectorId(ConnectionResource connectionResource) {
        if (connectionResource == null) {
            return 0;
        }
        ConnectorResource fromConnector = connectionResource.getFromConnector();
        if (fromConnector == null) {
            return 0;
        }
        int connectorId = fromConnector.getConnectorId();
        return connectorId;
    }

    private int dtoToConnectorConnectorId(ConnectionResource connectionResource) {
        if (connectionResource == null) {
            return 0;
        }
        ConnectorResource toConnector = connectionResource.getToConnector();
        if (toConnector == null) {
            return 0;
        }
        int connectorId = toConnector.getConnectorId();
        return connectorId;
    }
}

