/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.mysql;

import com.becon.opencelium.backend.database.mysql.entity.BusinessLayout;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.mapper.mysql.ConnectionMapper;
import com.becon.opencelium.backend.mapper.mysql.EnhancementMapper;
import com.becon.opencelium.backend.mapper.utils.HelperMapper;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connection.binding.EnhancementDTO;
import com.becon.opencelium.backend.utility.StringUtility;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionMapperImpl
implements ConnectionMapper {
    @Autowired
    private EnhancementMapper enhancementMapper;
    @Autowired
    private HelperMapper helperMapper;

    public Connection toEntity(ConnectionDTO dto) {
        Integer connectorId1;
        if (dto == null) {
            return null;
        }
        Connection connection = new Connection();
        connection.setId(dto.getConnectionId());
        Integer connectorId = this.dtoFromConnectorConnectorId(dto);
        if (connectorId != null) {
            connection.setFromConnector(connectorId.intValue());
        }
        if ((connectorId1 = this.dtoToConnectorConnectorId(dto)) != null) {
            connection.setToConnector(connectorId1.intValue());
        }
        connection.setTitle(dto.getTitle());
        connection.setDescription(dto.getDescription());
        connection.setCategoryId(dto.getCategoryId());
        connection.setIcon(StringUtility.findImageFromUrl((String)dto.getIcon()));
        connection.setEnhancements(dto.getFieldBinding() != null ? dto.getFieldBinding().stream().map(e -> {
            Enhancement enh = this.enhancementMapper.toEntity(e.getEnhancement());
            if (enh == null) {
                enh = new Enhancement();
            }
            enh.setId(e.getEnhancementId());
            return enh;
        }).toList() : null);
        connection.setBusinessLayout(dto.getBusinessLayout() != null ? new BusinessLayout(dto.getBusinessLayout(), connection) : null);
        return connection;
    }

    public ConnectionDTO toDTO(Connection entity) {
        if (entity == null) {
            return null;
        }
        ConnectionDTO connectionDTO = new ConnectionDTO();
        connectionDTO.setConnectionId(entity.getId());
        connectionDTO.setFromConnector(this.helperMapper.getConnectorDTOById(entity.getFromConnector()));
        connectionDTO.setToConnector(this.helperMapper.getConnectorDTOById(entity.getToConnector()));
        connectionDTO.setFieldBinding(this.helperMapper.getFieldBindings(entity.getEnhancements()));
        connectionDTO.setTitle(entity.getTitle());
        connectionDTO.setDescription(entity.getDescription());
        connectionDTO.setCategoryId(entity.getCategoryId());
        connectionDTO.setIcon(StringUtility.resolveImagePath((String)entity.getIcon()));
        return connectionDTO;
    }

    public List<Enhancement> toEnhancementAll(List<EnhancementDTO> dtos) {
        if (dtos == null) {
            return null;
        }
        ArrayList<Enhancement> list = new ArrayList<Enhancement>(dtos.size());
        for (EnhancementDTO enhancementDTO : dtos) {
            list.add(this.enhancementMapper.toEntity(enhancementDTO));
        }
        return list;
    }

    private Integer dtoFromConnectorConnectorId(ConnectionDTO connectionDTO) {
        if (connectionDTO == null) {
            return null;
        }
        ConnectorDTO fromConnector = connectionDTO.getFromConnector();
        if (fromConnector == null) {
            return null;
        }
        Integer connectorId = fromConnector.getConnectorId();
        if (connectorId == null) {
            return null;
        }
        return connectorId;
    }

    private Integer dtoToConnectorConnectorId(ConnectionDTO connectionDTO) {
        if (connectionDTO == null) {
            return null;
        }
        ConnectorDTO toConnector = connectionDTO.getToConnector();
        if (toConnector == null) {
            return null;
        }
        Integer connectorId = toConnector.getConnectorId();
        if (connectorId == null) {
            return null;
        }
        return connectorId;
    }
}

