/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker.paginator.entity;

import com.becon.opencelium.backend.invoker.paginator.entity.PageParamRule;
import com.becon.opencelium.backend.invoker.paginator.entity.Pagination;
import com.becon.opencelium.backend.invoker.paginator.enums.PageParam;
import com.becon.opencelium.backend.invoker.paginator.enums.PageParamAction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class Pagination
implements Cloneable {
    private List<PageParamRule> pageParamRules;
    private int currentSize;

    public Pagination(List<PageParamRule> pageParamRules) {
        this.pageParamRules = pageParamRules;
    }

    public List<PageParamRule> getPageParamRules() {
        return this.pageParamRules;
    }

    public String getParamValue(PageParam param) {
        return this.findParam(param).getValue();
    }

    public void changeParamValue(PageParam param, String newValue) {
        this.findParam(param).setValue(newValue);
    }

    public PageParamRule findParam(PageParam param) {
        return this.pageParamRules.stream().filter(p -> p.getParam() == param).findFirst().orElseThrow(() -> new RuntimeException("\"Parameter \\\"" + param + "\\\" not found in pagination\""));
    }

    public boolean existsParam(PageParam param) {
        return this.pageParamRules.stream().filter(p -> p.getParam() == param).findFirst().orElse(null) != null;
    }

    public boolean hasMore() {
        String url;
        String result;
        this.currentSize = this.getCurrentSize();
        if (this.existsParam(PageParam.HAS_MORE) && (result = this.findParam(PageParam.HAS_MORE).getValue()) != null && !result.isEmpty()) {
            return Boolean.parseBoolean(result);
        }
        if (this.existsParam(PageParam.SIZE)) {
            int size = Integer.parseInt(this.getParamValue(PageParam.SIZE));
            return this.currentSize < size;
        }
        if (this.existsParam(PageParam.CURSOR) && ((result = this.findParam(PageParam.CURSOR).getValue()) == null || result.isEmpty())) {
            return false;
        }
        if (this.existsParam(PageParam.LINK) && !(url = this.getParamValue(PageParam.LINK)).isEmpty()) {
            try {
                URI uri = new URI(url);
                return !uri.getRawQuery().contains("null");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public int getCurrentSize() {
        PageParamRule paramRule = this.findParam(PageParam.RESULT);
        String payload = paramRule.getValue();
        String jsonPath = paramRule.getRefPath();
        this.currentSize = (Integer)JsonPath.parse((String)payload).read(jsonPath + ".length()", new Predicate[0]);
        return this.currentSize;
    }

    public URI insertPageValue(URI uri) throws URISyntaxException {
        String url = uri.toString();
        for (PageParamRule paramRule : this.pageParamRules) {
            String ref = paramRule.getRef();
            if (ref == null) continue;
            PageParamAction action = paramRule.getAction();
            if (!ref.contains("request.url.$")) continue;
            String param = paramRule.getRefSuffix();
            if (!action.equals((Object)PageParamAction.WRITE)) continue;
            url = uri.getRawQuery() == null ? url.concat("?" + param + "=" + paramRule.getValue()) : url.concat("&" + param + "=" + paramRule.getValue());
        }
        return new URI(url);
    }

    public void insertPageValue(HttpHeaders headers) {
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef() != null).filter(paramRule -> paramRule.getRef().contains("request.header.$")).filter(paramRule -> paramRule.getAction().equals((Object)PageParamAction.WRITE)).forEach(paramRule -> {
            String key = paramRule.getRefSuffix();
            headers.add(key, paramRule.getValue());
        });
    }

    public String insertPageValue(String payload) {
        String[] result = new String[1];
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef().equals("request.body.$")).filter(paramRule -> paramRule.getAction().equals((Object)PageParamAction.WRITE)).forEach(paramRule -> {
            String path = paramRule.getRefPath();
            result[0] = (String)JsonPath.parse((String)payload).set(path, (Object)paramRule.getValue(), new Predicate[0]).json();
        });
        return result[0];
    }

    public void updateParamValues(ResponseEntity<String> response) {
        HttpRepository httpRepository = new HttpRepository(response);
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef() != null).filter(paramRule -> paramRule.getRef().split("\\.", 2)[0].equals("response")).forEach(paramRule -> {
            Object value = httpRepository.findValueByPath(paramRule.getRef());
            if (paramRule.getParam().equals((Object)PageParam.RESULT)) {
                if (paramRule.getValue() == null || paramRule.getValue().isEmpty()) {
                    paramRule.setValue((String)response.getBody());
                    return;
                }
                String path = paramRule.getRefPath();
                String result = Pagination.mergeArrayIntoObject((String)paramRule.getValue(), (String)value, (String)path);
                paramRule.setValue(result);
                return;
            }
            if (paramRule.getParam().equals((Object)PageParam.PAGE) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                value = "" + (Integer.parseInt((String)value) + 1);
            }
            if (paramRule.getParam().equals((Object)PageParam.OFFSET) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                int limit = Integer.parseInt(this.findParam(PageParam.LIMIT).getValue());
                value = "" + (Integer.parseInt((String)value) + limit);
            }
            paramRule.setValue((String)value);
        });
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef() == null).forEach(paramRule -> {
            Object value = paramRule.getValue();
            if (paramRule.getParam().equals((Object)PageParam.PAGE) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                value = "" + (Integer.parseInt((String)value) + 1);
            }
            if (paramRule.getParam().equals((Object)PageParam.OFFSET) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                int limit = Integer.parseInt(this.findParam(PageParam.LIMIT).getValue());
                value = "" + (Integer.parseInt((String)value) + limit);
            }
            paramRule.setValue((String)value);
        });
    }

    public Pagination clone() {
        Pagination clone;
        try {
            clone = (Pagination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new Pagination(this.pageParamRules.stream().map(PageParamRule::clone).collect(Collectors.toList()));
        }
        clone.pageParamRules = this.pageParamRules.stream().map(PageParamRule::clone).collect(Collectors.toList());
        return clone;
    }

    public static String mergeArrayIntoObject(String obj, String arr, String jsonPath) {
        try {
            String jsonPointer = Pagination.convertJSONPathToPointer((String)jsonPath);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(obj);
            ArrayNode arrNode = (ArrayNode)mapper.readTree(arr);
            JsonNode dataNode = rootNode.at(jsonPointer);
            if (!(dataNode instanceof ArrayNode)) {
                throw new IllegalArgumentException("Path does not point to an array node");
            }
            ((ArrayNode)dataNode).addAll(arrNode);
            return rootNode.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertJSONPathToPointer(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            return "";
        }
        String jsonPointer = jsonPath.trim().substring(1).replaceAll("\\.", "/");
        jsonPointer = jsonPointer.replaceAll("\\[(\\d+)\\]", "/$1");
        return jsonPointer;
    }
}

