/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker.paginator.entity;

import com.becon.opencelium.backend.invoker.paginator.enums.PageParam;
import com.becon.opencelium.backend.invoker.paginator.enums.PageParamAction;
import java.util.function.Function;

public class PageParamRule
implements Cloneable {
    private String value;
    private String ref;
    private PageParam param;
    private PageParamAction action;

    public PageParamRule() {
    }

    public PageParamRule(String value, String ref, PageParam param, PageParamAction action) {
        this.value = value;
        this.ref = ref;
        this.param = param;
        this.action = action;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public PageParam getParam() {
        return this.param;
    }

    public void setParam(PageParam param) {
        this.param = param;
    }

    public PageParamAction getAction() {
        return this.action;
    }

    public void setAction(PageParamAction action) {
        this.action = action;
    }

    public String getRefSuffix() {
        return this.parseRef(index -> this.ref.substring(index + 3));
    }

    public String getRefPath() {
        return this.parseRef(index -> this.ref.substring(index + 1));
    }

    public String getRefPrefix() {
        return this.parseRef(index -> this.ref.substring(0, (int)index));
    }

    public String toString() {
        return "PageParamRule{value='" + this.value + "', ref='" + this.ref + "', param=" + this.param + ", action=" + this.action + "}";
    }

    public PageParamRule clone() {
        PageParamRule clone;
        try {
            clone = (PageParamRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new PageParamRule(this.getValue(), this.getRef(), this.getParam(), this.getAction());
        }
        return clone;
    }

    private String parseRef(Function<Integer, String> function) {
        if (this.ref == null || this.ref.isEmpty()) {
            return "";
        }
        int index = this.ref.indexOf(".$");
        if (index != -1) {
            return function.apply(index);
        }
        return "";
    }
}

