/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.connection;

import com.becon.opencelium.backend.database.mysql.entity.ConnectionHistory;
import com.becon.opencelium.backend.database.mysql.service.ConnectionHistoryService;
import com.becon.opencelium.backend.enums.Action;
import com.becon.opencelium.backend.gc.base.Pool;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;

public class ConnectionPool
extends Pool<Long> {
    private final Logger log;
    private final ConnectionHistoryService connectionHistoryService;

    public ConnectionPool(ConnectionHistoryService connectionHistoryService, Logger log) {
        this.connectionHistoryService = connectionHistoryService;
        this.log = log;
    }

    public void initialize(List<Long> newElements) {
        boolean changed = false;
        long maxDuration = 2400L;
        for (Long elem : newElements) {
            Pool.PoolObj poolObj = new Pool.PoolObj((Pool)this, (Object)elem);
            List all = this.connectionHistoryService.findAllWithInterval(((Long)poolObj.getElement()).longValue(), maxDuration);
            if (all == null || all.isEmpty()) {
                this.toDeletePool.add(elem);
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status RED. Because it hasn't any history while last {} seconds.", (Object)elem, (Object)maxDuration);
                changed = true;
                continue;
            }
            if (all.size() == 1 && ((ConnectionHistory)all.get(0)).getAction().equals((Object)Action.CREATE)) {
                if (((ConnectionHistory)all.get(0)).getCreated().isAfter(LocalDateTime.now().minus(120000L, ChronoUnit.MILLIS))) {
                    this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status NEW. Because it is created less than {} seconds ago. ", (Object)elem, (Object)120L);
                    changed = true;
                    this.newPool.put(elem, poolObj);
                    continue;
                }
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status RED. Because it is created more than {} seconds ago.", (Object)elem, (Object)120L);
                changed = true;
                this.toDeletePool.add(elem);
                continue;
            }
            if (all.size() == 1 && ((ConnectionHistory)all.get(0)).getAction() != Action.DELETE) continue;
            all.stream().filter(ch -> ch.getCreated().isAfter(LocalDateTime.now().minus(480000L, ChronoUnit.MILLIS)) && ch.getAction() != Action.CREATE && ch.getAction() != Action.DELETE).findAny().ifPresentOrElse(ch -> all.stream().filter(chh -> chh.getCreated().isAfter(LocalDateTime.now().minus(120000L, ChronoUnit.MILLIS)) && ch.getAction() != Action.CREATE && ch.getAction() != Action.DELETE).findAny().ifPresentOrElse(chhh -> {
                this.youngPool.put(elem, poolObj);
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status YOUNG. Because it is modified less than {} seconds ago.", (Object)elem, (Object)240L);
            }, () -> {
                poolObj.setFairness(3);
                this.oldPool.put(elem, poolObj);
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status OLD. Because it is modified less than {} seconds ago.", (Object)elem, (Object)480L);
            }), () -> {
                this.toDeletePool.add(elem);
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status RED. Because it is modified more than {} seconds ago.", (Object)elem, (Object)480L);
            });
            changed = true;
        }
        if (changed) {
            this.logTotalElements();
        }
    }

    public void allocate(Long newElement) {
        Pool.PoolObj poolObj = new Pool.PoolObj((Pool)this, (Object)newElement);
        this.rotate(poolObj);
    }

    public void reconsiderNewPool(Long element) {
        List histories = this.connectionHistoryService.findAllWithConnectionId(element);
        if (histories == null || histories.isEmpty() || histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.CREATE) {
            if (((Pool.PoolObj)this.newPool.get(element)).getTimestamp() + 120000L < System.currentTimeMillis()) {
                this.evictFromNewPool((Object)element);
                this.toDeletePool.add(element);
                this.log.info("Connection[id = {}]'s status changed to RED. Because it's time over for NEW", (Object)element);
                this.logTotalElements();
            } else if (histories != null && histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.DELETE) {
                this.evictFromNewPool((Object)element);
                this.log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is deleted.", (Object)element);
                this.logTotalElements();
            }
            return;
        }
        this.evictFromNewPool((Object)element);
        Pool.PoolObj poolObj = new Pool.PoolObj((Pool)this, (Object)element);
        poolObj.setFairness(1);
        this.youngPool.put(element, poolObj);
        this.log.info("Connection[id = {}]'s status changed to YOUNG. Because it is changed recently", (Object)element);
        this.logTotalElements();
    }

    public void reconsiderYoungPool(Long element) {
        List histories = this.connectionHistoryService.findAllWithInterval(element.longValue(), (System.currentTimeMillis() - ((Pool.PoolObj)this.youngPool.get(element)).getTimestamp()) / 1000L);
        if (histories == null || histories.isEmpty() || histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.CREATE) {
            if (((Pool.PoolObj)this.youngPool.get(element)).getTimestamp() + 240000L < System.currentTimeMillis()) {
                this.evictFromYoungPool((Object)element);
                this.toDeletePool.add(element);
                this.log.info("Connection[id = {}]'s status changed to RED. Because it's time over for YOUNG", (Object)element);
                this.logTotalElements();
            } else if (histories != null && histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.DELETE) {
                this.evictFromYoungPool((Object)element);
                this.log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is deleted.", (Object)element);
                this.logTotalElements();
            }
            return;
        }
        ((Pool.PoolObj)this.youngPool.get(element)).incrementFairness();
        if (((Pool.PoolObj)this.youngPool.get(element)).getFairness() > 2) {
            Pool.PoolObj removed = (Pool.PoolObj)this.youngPool.remove(element);
            removed.setTimestamp(System.currentTimeMillis());
            this.oldPool.put(element, removed);
            this.log.info("Connection[id = {}]'s status changed to OLD. Because it is changed recently", (Object)element);
            this.logTotalElements();
        } else {
            ((Pool.PoolObj)this.youngPool.get(element)).setTimestamp(System.currentTimeMillis());
        }
    }

    public void reconsiderOldPool(Long element) {
        List histories = this.connectionHistoryService.findAllWithInterval(element.longValue(), (System.currentTimeMillis() - ((Pool.PoolObj)this.oldPool.get(element)).getTimestamp()) / 1000L);
        if (histories == null || histories.isEmpty() || histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.CREATE) {
            if (((Pool.PoolObj)this.oldPool.get(element)).getTimestamp() + 480000L < System.currentTimeMillis()) {
                this.evictFromOldPool((Object)element);
                this.toDeletePool.add(element);
                this.log.info("Connection[id = {}]'s status changed to RED. Because it's time over for OLD", (Object)element);
                this.logTotalElements();
            } else if (histories != null && histories.size() == 1 && ((ConnectionHistory)histories.get(0)).getAction() == Action.DELETE) {
                this.evictFromNewPool((Object)element);
                this.log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is deleted.", (Object)element);
                this.logTotalElements();
            }
            return;
        }
        ((Pool.PoolObj)this.oldPool.get(element)).incrementFairness();
        ((Pool.PoolObj)this.oldPool.get(element)).setTimestamp(System.currentTimeMillis());
    }

    private void rotate(Pool.PoolObj poolObj) {
        List<ConnectionHistory> all = this.connectionHistoryService.findAllWithConnectionId((Long)poolObj.getElement());
        if (all == null || all.isEmpty()) {
            return;
        }
        if (all.size() == 1 && ((ConnectionHistory)all.get(0)).getAction() == Action.CREATE) {
            if (((ConnectionHistory)all.get(0)).getCreated().isAfter(LocalDateTime.now().minus(120000L, ChronoUnit.MILLIS))) {
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status NEW. Because it is created less than {} seconds ago. ", poolObj.getElement(), (Object)120L);
                this.newPool.put((Long)poolObj.getElement(), poolObj);
            } else {
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status RED. Because it is created more than {} seconds ago. ", poolObj.getElement(), (Object)120L);
                this.toDeletePool.add((Long)poolObj.getElement());
            }
        } else {
            int fairness = 0;
            all = all.stream().filter(ch -> ch.getAction() == Action.MODIFY || ch.getAction() == Action.UNDO).sorted(Comparator.comparingLong(c -> Timestamp.valueOf(c.getCreated()).getTime())).toList();
            LocalDateTime now = LocalDateTime.now();
            for (int i = 0; i < all.size() && all.get(i).getCreated().isAfter(now.minus(120000L * (long)(i + 1), ChronoUnit.MILLIS)) && ++fairness <= 2; ++i) {
            }
            if (fairness <= 2 && fairness > 0) {
                poolObj.setFairness(fairness);
                poolObj.setTimestamp(Timestamp.valueOf(all.get(0).getCreated()).getTime());
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status YOUNG. Because it is modified {} times.", poolObj.getElement(), (Object)fairness);
                this.youngPool.put((Long)poolObj.getElement(), poolObj);
            } else if (fairness > 2) {
                poolObj.setFairness(fairness);
                poolObj.setTimestamp(Timestamp.valueOf(all.get(0).getCreated()).getTime());
                this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status OLD. Because it is modified {} times.", poolObj.getElement(), (Object)fairness);
                this.oldPool.put((Long)poolObj.getElement(), poolObj);
            } else {
                int fairness2 = 2;
                for (int i = 0; i < all.size() && all.get(i).getCreated().isAfter(now.minus(480000L * (long)(i + 1), ChronoUnit.MILLIS)); ++i) {
                    ++fairness2;
                }
                if (fairness2 == 2) {
                    this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status RED. Because it is modified but too long times ago.", poolObj.getElement());
                    this.toDeletePool.add((Long)poolObj.getElement());
                } else {
                    poolObj.setFairness(fairness + fairness2);
                    poolObj.setTimestamp(Timestamp.valueOf(all.get(0).getCreated()).getTime());
                    this.log.info("Connection[id = {}] is marked as WILL_BE_DELETED with status OLD. Because it is modified {} times", poolObj.getElement(), (Object)(fairness + fairness2));
                    this.oldPool.put((Long)poolObj.getElement(), poolObj);
                }
            }
        }
        this.logTotalElements();
    }

    public void logTotalElements() {
        this.log.info("Connections in GC - NEW: {}, YOUNG: {}, OLD: {}, RED: {}", new Object[]{this.newPool.size(), this.youngPool.size(), this.oldPool.size(), this.toDeletePool.size()});
    }
}

