/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.base.strategy;

import com.becon.opencelium.backend.gc.base.strategy.CronTriggerStrategy;
import com.becon.opencelium.backend.gc.base.strategy.GCTriggerStrategy;
import com.becon.opencelium.backend.gc.base.strategy.OnApplicationReadyTriggerStrategy;
import com.becon.opencelium.backend.gc.base.strategy.PeriodicTriggerStrategy;
import com.becon.opencelium.backend.gc.base.strategy.StrategyConfig;

public abstract class TriggerStrategyFactory {
    public static <T> GCTriggerStrategy getStrategy(StrategyConfig strategyConfig) {
        return switch (strategyConfig.getStrategy()) {
            case "on-restart" -> new OnApplicationReadyTriggerStrategy();
            case "periodic" -> new PeriodicTriggerStrategy(strategyConfig.getFixedDelay(), strategyConfig.getInitialDelay());
            case "cron" -> new CronTriggerStrategy(strategyConfig.getCron());
            default -> new PeriodicTriggerStrategy();
        };
    }
}

