/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.base.strategy;

import com.becon.opencelium.backend.configuration.ApplicationContextProvider;
import com.becon.opencelium.backend.gc.base.RunGCEvent;
import com.becon.opencelium.backend.gc.base.strategy.GCTriggerStrategy;
import com.becon.opencelium.backend.gc.connection.ConnectionForGC;
import java.time.Clock;
import java.util.concurrent.ThreadFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class CronTriggerStrategy<T>
implements GCTriggerStrategy {
    private String cron;
    private static final String DEFAULT_CRON = "0 0/1 * * * ?";
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ThreadPoolTaskScheduler taskScheduler;

    public CronTriggerStrategy(String cron) {
        try {
            new CronTrigger(cron, Clock.systemDefaultZone().getZone());
            this.cron = cron;
        }
        catch (Exception e) {
            this.cron = DEFAULT_CRON;
        }
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.taskScheduler.setPoolSize(2);
        this.taskScheduler.initialize();
        this.taskScheduler.setThreadFactory((ThreadFactory)new CustomizableThreadFactory("GarbageCollector[Connection]-"));
        this.applicationEventPublisher = ApplicationContextProvider.getApplicationContext();
    }

    public void startTrigger() {
        this.taskScheduler.schedule(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new RunGCEvent((Object)new ConnectionForGC())), (Trigger)new CronTrigger(this.cron, Clock.systemDefaultZone().getZone()));
    }

    public void shutdown() {
        this.taskScheduler.shutdown();
    }
}

