/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.socket;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class WebSocketUserSubscriptionRegistry {
    private final Map<Integer, Set<String>> userSubscriptions = new ConcurrentHashMap();

    public synchronized boolean add(int userId, String destination) {
        return this.userSubscriptions.computeIfAbsent(userId, k -> ConcurrentHashMap.newKeySet()).add(destination);
    }

    public void remove(int userId, String destination) {
        ((Set)this.userSubscriptions.get(userId)).remove(destination);
    }

    public void remove(int userId) {
        this.userSubscriptions.remove(userId);
    }

    public boolean hasSubscription(String destination) {
        return this.userSubscriptions.values().stream().anyMatch(set -> set.contains(destination));
    }
}

