/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.service;

import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.SchedulerService;
import com.becon.opencelium.backend.execution.service.ExecutionObjectService;
import com.becon.opencelium.backend.mapper.execution.ConnectionExMapper;
import com.becon.opencelium.backend.quartz.QuartzJobScheduler;
import com.becon.opencelium.backend.resource.execution.ConnectionEx;
import com.becon.opencelium.backend.resource.execution.ExecutionObj;
import com.becon.opencelium.backend.resource.execution.ProxyEx;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ExecutionObjectServiceImp
implements ExecutionObjectService {
    private final Environment env;
    private final ConnectionExMapper connectionMapper;
    private final SchedulerService schedulerService;
    private final ConnectionMngService connectionMngService;
    private final ConnectionService connectionService;

    public ExecutionObjectServiceImp(Environment environment, ConnectionExMapper connectionMapper, @Qualifier(value="schedulerServiceImp") SchedulerService schedulerService, @Qualifier(value="connectionMngServiceImp") ConnectionMngService connectionMngService, @Qualifier(value="connectionServiceImp") ConnectionService connectionService) {
        this.connectionMapper = connectionMapper;
        this.schedulerService = schedulerService;
        this.connectionMngService = connectionMngService;
        this.connectionService = connectionService;
        this.env = environment;
    }

    public ExecutionObj buildObj(QuartzJobScheduler.ScheduleData data) {
        int scheduleId = data.getScheduleId();
        Scheduler scheduler = this.schedulerService.getById(scheduleId);
        ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(scheduler.getConnection().getId());
        ExecutionObj executionObj = new ExecutionObj();
        ConnectionEx connectionEx = this.connectionMapper.toEntity(connectionMng);
        connectionEx.setConnectionName(this.getConnectionName(connectionMng.getConnectionId()));
        executionObj.setConnection(connectionEx);
        executionObj.setWebhookVars(data.getQueryParams());
        String host = this.env.getProperty("opencelium.rest_template.proxy.host", "");
        String port = this.env.getProperty("opencelium.rest_template.proxy.port", "");
        String user = this.env.getProperty("opencelium.rest_template.proxy.username", "");
        String password = this.env.getProperty("opencelium.rest_template.proxy.password", "");
        ProxyEx proxy = new ProxyEx(host, port, user, password);
        executionObj.setProxy(proxy);
        return executionObj;
    }

    private String getConnectionName(Long connectionId) {
        Connection connection = this.connectionService.getById(connectionId);
        return connection.getTitle();
    }
}

