/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.rdata.extractor;

import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.enums.DataRef;
import com.becon.opencelium.backend.execution.rdata.extractor.Extractor;
import com.becon.opencelium.backend.invoker.InvokerRequestBuilder;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class BodyExtractor
implements Extractor {
    private List<RequestData> requestData;
    private List<FunctionInvoker> functionInvokers;
    private boolean disableSll;

    public Extractor setRequestData(List<RequestData> requestData) {
        this.requestData = requestData;
        return this;
    }

    public Extractor setFunctions(List<FunctionInvoker> functionInvokerList) {
        this.functionInvokers = functionInvokerList;
        return this;
    }

    public Extractor disableSslValidation(boolean disable) {
        this.disableSll = disable;
        return this;
    }

    public Optional<String> getValue(String fieldName) {
        String expr = this.requestData.stream().filter(rq -> rq.getField().equals(fieldName)).map(RequestData::getValue).findFirst().orElse(null);
        if (expr == null) {
            return Optional.empty();
        }
        InvokerRequestBuilder invokerRequestBuilder = new InvokerRequestBuilder();
        for (String ref : this.extractRefs(expr)) {
            FunctionInvoker functionInvoker = this.getFunctionInvoker(ref);
            ResponseEntity response = invokerRequestBuilder.setRequestData(this.requestData).setSslCert(this.disableSll).setFunction(functionInvoker).sendRequest();
            String path = this.getPathFromRef(expr);
            String value = this.getValueFromResponse(path, response);
            if (value == null) {
                value = "";
            }
            expr = expr.replace(ref, value);
        }
        return Optional.of(expr);
    }

    private FunctionInvoker getFunctionInvoker(String bodyRef) {
        String functionName = bodyRef.split("\\.")[0].replace("%{", "");
        if (functionName.equals("body") || functionName.equals("header")) {
            return this.functionInvokers.stream().filter(f -> f.getName().equals("test")).findFirst().get();
        }
        return this.functionInvokers.stream().filter(f -> f.getName().equals(functionName)).findFirst().orElseThrow(() -> new RuntimeException("Function from \"" + bodyRef + "\" not found in invoker operations"));
    }

    private String getPathFromRef(String bodyRef) {
        StringBuilder sb = new StringBuilder(bodyRef);
        sb.delete(0, 2);
        sb.deleteCharAt(sb.length() - 1);
        String methodName = sb.toString().split("\\.")[0];
        sb.delete(sb.indexOf(methodName), methodName.length() + 1);
        return sb.toString();
    }

    private String getValueFromResponse(String path, ResponseEntity<String> response) {
        ArrayList<String> pathParts = new ArrayList<String>(Arrays.asList(path.split("\\.")));
        boolean isHeader = ((String)pathParts.get(0)).contains("header");
        pathParts.remove(0);
        if (isHeader) {
            HttpHeaders httpHeaders = response.getHeaders();
            if (httpHeaders.get(pathParts.get(0)) == null) {
                return null;
            }
            return (String)httpHeaders.get(pathParts.get(0)).get(0);
        }
        if (path.equals("body")) {
            return Objects.requireNonNull((String)response.getBody()).replace("\"", "");
        }
        String body = (String)response.getBody();
        MediaType contentType = response.getHeaders().getContentType();
        if (this.isJson(body)) {
            contentType = MediaType.APPLICATION_JSON;
        } else if (contentType == null) {
            throw new RuntimeException("Content-Type is not defined in header for response: " + response);
        }
        return (String)this.readPayload(contentType.getSubtype()).apply(pathParts, body);
    }

    private BiFunction<List<String>, String, String> readPayload(String contentType) {
        if (contentType.contains("json")) {
            return (pathParts, json) -> {
                String jpath = "$." + pathParts.stream().map(Object::toString).collect(Collectors.joining("."));
                if (!this.pathExists(json, jpath)) {
                    throw new RuntimeException("Path " + jpath + " not found in " + json);
                }
                return (String)JsonPath.read((String)json, (String)jpath, (Predicate[])new Predicate[0]);
            };
        }
        if (contentType.contains("xml")) {
            return (pathParts, xml) -> {
                String xmlPath = "/" + pathParts.stream().map(Object::toString).collect(Collectors.joining("/"));
                XPathFactory xpathfactory = XPathFactory.newInstance();
                XPath xpath = xpathfactory.newXPath();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = BodyExtractor.convertStringToXMLDocument((String)xml);
                    XPathExpression expr = xpath.compile(xmlPath);
                    return expr.evaluate(document, XPathConstants.STRING).toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        throw new RuntimeException("Couldn't determine Content-Type: " + contentType);
    }

    private boolean isJson(String payload) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.readTree(payload);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> extractRefs(String expr) {
        ArrayList<String> refs = new ArrayList<String>();
        Pattern pattern = Pattern.compile(DataRef.BODY.toString());
        Matcher matcher = pattern.matcher(expr);
        while (matcher.find()) {
            refs.add(matcher.group());
        }
        return refs;
    }

    private boolean pathExists(String json, String jpath) {
        try {
            JsonPath.read((String)json, (String)jpath, (Predicate[])new Predicate[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

