/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.rdata.extractor;

import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.execution.rdata.extractor.Extractor;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class BasicExtractor
implements Extractor {
    private List<RequestData> requestData;
    private List<FunctionInvoker> functionInvokers;

    public Extractor setRequestData(List<RequestData> requestData) {
        this.requestData = requestData;
        return this;
    }

    public Extractor setFunctions(List<FunctionInvoker> functionInvokerList) {
        this.functionInvokers = functionInvokerList;
        return this;
    }

    public Optional<String> getValue(String fieldName) {
        String expr = this.requestData.stream().filter(rq -> rq.getField().equals(fieldName)).map(RequestData::getValue).findFirst().orElse(null);
        if (expr == null) {
            return Optional.of("");
        }
        int openBrace = expr.indexOf("{") + 1;
        int closeBrace = expr.indexOf("}");
        String data = expr.substring(openBrace, closeBrace);
        String[] credentials = data.split(":");
        String username = this.requestData.stream().filter(d -> d.getField().equals(credentials[0])).findFirst().orElseThrow(() -> new RuntimeException(credentials[0] + "property not found in request_data")).getValue();
        String password = this.requestData.stream().filter(d -> d.getField().equals(credentials[1])).findFirst().orElseThrow(() -> new RuntimeException(credentials[1] + "property not found in request_data")).getValue();
        String authCode = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        return Optional.of(authCode);
    }
}

