/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.rdata;

import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.enums.DataRef;
import com.becon.opencelium.backend.execution.rdata.RequiredDataService;
import com.becon.opencelium.backend.execution.rdata.extractor.Extractor;
import com.becon.opencelium.backend.execution.rdata.extractor.ExtractorFactory;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import java.util.List;
import java.util.Optional;

public class RequiredDataServiceImp
implements RequiredDataService {
    private final List<RequestData> requestData;
    private final List<FunctionInvoker> functionInvokerList;
    private final Connector connector;

    public RequiredDataServiceImp(Connector connector, List<RequestData> requestData, List<FunctionInvoker> functionInvokerList) {
        this.requestData = requestData;
        this.functionInvokerList = functionInvokerList;
        this.connector = connector;
    }

    public Optional<String> getValue(RequestData rqsd) {
        DataRef refType = this.getRefType(rqsd.getValue());
        if (refType == null) {
            return Optional.of(rqsd.getValue());
        }
        Extractor extractor = ExtractorFactory.getInstance((DataRef)refType);
        return extractor.setRequestData(this.requestData).setFunctions(this.functionInvokerList).disableSslValidation(this.connector.isSslValidation()).getValue(rqsd.getField());
    }

    private DataRef getRefType(String expression) {
        return DataRef.getType((String)expression);
    }
}

