/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.oc721;

import com.becon.opencelium.backend.enums.RelationalOperator;
import com.becon.opencelium.backend.resource.execution.OperatorEx;
import com.becon.opencelium.backend.utility.ReferenceUtility;

public class Loop {
    private String ref;
    private String delimiter;
    private String iterator;
    private int index;
    private String value;
    private RelationalOperator operator;

    public static Loop fromEx(OperatorEx operatorEx) {
        Loop result = new Loop();
        result.setIterator(operatorEx.getIterator());
        String expression = operatorEx.getExpression();
        Object ref = ReferenceUtility.extractRef((String)expression, (String)"\\{%#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+\\%}");
        if (expression.startsWith(RelationalOperator.FOR_IN.getName())) {
            result.setOperator(RelationalOperator.FOR_IN);
            if (ref == null) {
                ref = ReferenceUtility.extractRef((String)expression, (String)"\\$\\{(.*?)\\}");
                int index = ((String)ref).contains(":") ? ((String)ref).indexOf(":") : ((String)ref).length() - 1;
                ref = ((String)ref).substring(0, index) + "['*']~" + ((String)ref).substring(index);
            } else {
                ref = ReferenceUtility.extractDirectRef((String)ref) + "['*']~";
            }
        } else if (expression.startsWith(RelationalOperator.FOR.getName())) {
            result.setOperator(RelationalOperator.FOR);
        } else {
            if (ref == null) {
                throw new RuntimeException(ReferenceUtility.getContainedReferenceAndType((String)expression) + " is not supported for SPLIT_STRING");
            }
            result.setOperator(RelationalOperator.SPLIT_STRING);
            String delimiter = expression.replace((CharSequence)ref, " ").replace(RelationalOperator.SPLIT_STRING.getName(), "").replace("'", "").trim();
            result.setDelimiter(delimiter);
        }
        result.setRef((String)ref);
        return result;
    }

    public static boolean isIterator(String str) {
        return str != null && str.length() == 1 && Character.isLetter(str.charAt(0));
    }

    public String getRef() {
        return this.ref;
    }

    private void setRef(String ref) {
        this.ref = ref;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getIterator() {
        return this.iterator;
    }

    private void setIterator(String iterator) {
        this.iterator = iterator;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RelationalOperator getOperator() {
        return this.operator;
    }

    private void setOperator(RelationalOperator operator) {
        this.operator = operator;
    }
}

