/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.notification;

import com.becon.opencelium.backend.execution.notification.CommunicationTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

@Component
public class EmailServiceImpl
implements CommunicationTool {
    @Autowired(required=false)
    private JavaMailSender emailSender;
    @Autowired
    private Environment env;

    public void sendMessage(String destination, String subject, String text) {
        if (this.emailSender == null) {
            return;
        }
        String senderName = this.env.getProperty("spring.mail.opencelium.from");
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(destination);
            message.setSubject(subject);
            message.setText(text);
            if (senderName != null && !senderName.isEmpty()) {
                message.setFrom(senderName);
            }
            this.emailSender.send(message);
        }
        catch (MailException exception) {
            exception.printStackTrace();
        }
    }

    public void sendMessageUsingTemplate(String to, String subject, String templateModel) {
        String text = templateModel;
        this.sendMessage(to, subject, text);
    }
}

