/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.tracker;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilder;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilderFactory;
import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.context.PhaseContextManager;
import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.enums.LogDetailLevel;
import com.becon.opencelium.backend.execution.logger.enums.LogLineType;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.PhaseStatus;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.enums.SegmentType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.mapper.ParsedLogLineMapper;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import com.becon.opencelium.backend.execution.logger.schema.PhaseSchema;
import com.becon.opencelium.backend.execution.logger.schema.PhaseSchemaRegistry;
import com.becon.opencelium.backend.execution.logger.tracker.ExecutionTracker;
import com.becon.opencelium.backend.execution.logger.tracker.ExecutionTrackerImpl;
import com.becon.opencelium.backend.utility.ApplicationContextUtility;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecutionTrackerImpl
implements ExecutionTracker {
    private static final EnumSet<PhaseType> START_PHASES = EnumSet.of(PhaseType.EXECUTION_START, PhaseType.FLOWCHART_START, PhaseType.OPERATION_START, PhaseType.LOOP_START, PhaseType.IF_START);
    private static final EnumSet<PhaseType> END_PHASES = EnumSet.of(PhaseType.EXECUTION_END, PhaseType.FLOWCHART_END, PhaseType.OPERATION_END, PhaseType.LOOP_END, PhaseType.IF_END);
    private String execId;
    private String connId;
    private String flowId;
    private String connectorName;
    private final LogDetailLevel level;
    private final PhaseContextManager phaseContextManager;
    private final PhaseSchemaRegistry phaseSchemaRegistry;
    private final PhaseBuilderFactory builderFactory;
    private final ParsedLogLineMapper parsedLogLineMapper;

    public ExecutionTrackerImpl(String execId, String connId, String flowId, LogDetailLevel level) {
        this(execId, connId, flowId, level, new PhaseContextManager(), new PhaseSchemaRegistry(), (PhaseBuilderFactory)ApplicationContextUtility.getBean(PhaseBuilderFactory.class), (ParsedLogLineMapper)ApplicationContextUtility.getBean(ParsedLogLineMapper.class));
    }

    public ExecutionTrackerImpl(LogDetailLevel level) {
        this(null, null, null, level);
    }

    private ExecutionTrackerImpl(String execId, String connId, String flowId, LogDetailLevel level, PhaseContextManager phaseContextManager, PhaseSchemaRegistry phaseSchemaRegistry, PhaseBuilderFactory builderFactory, ParsedLogLineMapper parsedLogLineMapper) {
        this.execId = execId;
        this.connId = connId;
        this.flowId = flowId;
        this.level = Objects.requireNonNull(level, "LogDetailLevel must not be null");
        this.phaseContextManager = Objects.requireNonNull(phaseContextManager);
        this.phaseSchemaRegistry = Objects.requireNonNull(phaseSchemaRegistry);
        this.builderFactory = Objects.requireNonNull(builderFactory);
        this.parsedLogLineMapper = Objects.requireNonNull(parsedLogLineMapper);
    }

    public Optional<LogDataMng> buildLogData(ParsedLogLine parsedLine) {
        if (parsedLine == null || parsedLine.getStage() == null) {
            return Optional.empty();
        }
        LogLineType type = parsedLine.getType();
        return switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$LogLineType[type.ordinal()]) {
            case 1 -> this.handlePhase(parsedLine);
            case 2 -> this.handleSegment(parsedLine);
            default -> Optional.empty();
        };
    }

    private Optional<LogDataMng> handlePhase(ParsedLogLine line) {
        PhaseType phaseType = (PhaseType)line.getStage();
        PhaseCategory category = PhaseCategory.fromValue((PhaseType)phaseType);
        List allowedKeys = this.phaseSchemaRegistry.getPhasePropertyList(this.level, category);
        PhaseContext phaseContext = this.parsedLogLineMapper.toPhaseContext(line, allowedKeys);
        if (START_PHASES.contains(phaseType)) {
            return this.onPhaseStart(phaseType, category, phaseContext, line);
        }
        if (END_PHASES.contains(phaseType)) {
            return this.onPhaseEnd(category, phaseContext);
        }
        return Optional.empty();
    }

    private Optional<LogDataMng> onPhaseStart(PhaseType phaseType, PhaseCategory category, PhaseContext phaseContext, ParsedLogLine parsedLine) {
        phaseContext.setStatus(PhaseStatus.PENDING);
        if (phaseType == PhaseType.EXECUTION_START) {
            this.connId = (String)phaseContext.getProperties().get(LogLineKey.CONNECTION_ID);
            this.execId = (String)phaseContext.getProperties().get(LogLineKey.EXECUTION_ID);
            this.phaseContextManager.setExecId(this.execId);
            this.phaseContextManager.setConnectionId(this.connId);
        } else if (phaseType == PhaseType.FLOWCHART_START) {
            this.flowId = (String)phaseContext.getProperties().get(LogLineKey.FLOWCHART_ID);
            if (this.flowId == null || this.flowId.equals("null")) {
                throw new RuntimeException("Flow ID cannot be null");
            }
            this.connectorName = (String)phaseContext.getProperties().get(LogLineKey.CONNECTOR_NAME);
            this.phaseContextManager.setFlowId(this.flowId);
            this.phaseContextManager.setConnectorName(this.connectorName);
        }
        this.phaseContextManager.startPhase(phaseContext);
        PhaseSchema phaseSchema = this.getPhaseSchema(category);
        if (!this.shouldEmit(phaseSchema, parsedLine)) {
            return Optional.empty();
        }
        LogDataMng out = this.buildLogDataForContext(category, phaseContext);
        return Optional.ofNullable(out);
    }

    private Optional<LogDataMng> onPhaseEnd(PhaseCategory category, PhaseContext phaseContext) {
        PhaseContext closed = this.phaseContextManager.endPhase(phaseContext);
        LogDataMng out = this.buildLogDataForContext(category, closed);
        if (out != null) {
            out.setExecutionId(this.execId);
            Long cid = ExecutionTrackerImpl.parseLongOrNull((String)this.connId);
            if (cid != null) {
                out.setConnectionId(cid);
            }
        }
        return Optional.ofNullable(out);
    }

    private Optional<LogDataMng> handleSegment(ParsedLogLine parsedLine) {
        PhaseContext currentPhaseCtx = this.phaseContextManager.getCurrentPhase();
        if (currentPhaseCtx == null || currentPhaseCtx.getParsedLogLine() == null) {
            return Optional.empty();
        }
        PhaseType phaseType = (PhaseType)currentPhaseCtx.getParsedLogLine().getStage();
        PhaseCategory category = PhaseCategory.fromValue((PhaseType)phaseType);
        SegmentType segmentType = (SegmentType)parsedLine.getStage();
        Set allowedSegments = Optional.ofNullable(this.phaseSchemaRegistry.getAllowedSegments(this.level, category)).orElse(Collections.emptySet());
        if (!allowedSegments.contains(segmentType.name())) {
            return Optional.empty();
        }
        List keysToExtract = this.phaseSchemaRegistry.getSegmentPropertyList(this.level, category, segmentType);
        SegmentContext segmentContext = this.parsedLogLineMapper.toSegmentContext(parsedLine, keysToExtract);
        currentPhaseCtx.addSegment(segmentContext);
        PhaseSchema phaseSchema = this.getPhaseSchema(category);
        if (this.shouldEmit(phaseSchema, parsedLine)) {
            if (segmentType == SegmentType.EXCEPTION) {
                String indexPath = (String)currentPhaseCtx.getParsedLogLine().getProperties().get(LogLineKey.INDEX_PATH);
                this.phaseContextManager.addExceptionSegment(indexPath, segmentContext);
            }
            LogDataMng out = this.buildLogDataForContext(category, currentPhaseCtx);
            return Optional.ofNullable(out);
        }
        return Optional.empty();
    }

    private PhaseSchema getPhaseSchema(PhaseCategory category) {
        Map schemaMap = this.phaseSchemaRegistry.getSchema(this.level);
        return schemaMap != null ? (PhaseSchema)schemaMap.get(category) : null;
    }

    private LogDataMng buildLogDataForContext(PhaseCategory category, PhaseContext ctx) {
        PhaseBuilder builder = this.builderFactory.getBuilder(category);
        Long cid = ExecutionTrackerImpl.parseLongOrNull((String)this.connId);
        return builder.build(ctx, this.execId, this.flowId, cid);
    }

    private boolean shouldEmit(PhaseSchema phaseSchema, ParsedLogLine parsedLine) {
        String actual = parsedLine.getStage().name();
        if (Objects.equals(actual, SegmentType.EXCEPTION.name())) {
            return true;
        }
        if (phaseSchema == null) {
            return false;
        }
        List emitOn = phaseSchema.getEmitOn();
        return emitOn != null && emitOn.contains(actual);
    }

    private static Long parseLongOrNull(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }
}

