/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.parser;

import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.parser.LogLineParser;
import com.becon.opencelium.backend.execution.logger.service.LogStorageService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FlexiblePatternLogParser
implements LogLineParser {
    private final LogStorageService logStorageService;
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\b\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}\\b");
    private static final Pattern LOG_LEVEL_PATTERN = Pattern.compile("^\\s*(?:\\x1B\\[[\\d;]+m)?(INFO|DEBUG|ERROR|WARN|TRACE)\\b(?:\\x1B\\[[\\d;]+m)?");
    private static final Pattern KV_PATTERN = Pattern.compile("(\\w+)=((\"[^\"]*\"|\\{[^}]*\\}|[^\\s]+(?:\\s(?!\\w+=)[^\\s]+)*))");
    private static final Pattern HAS_PHASE_SEGMENT = Pattern.compile("(?m)^(?:(?!\").)*?\\b(?:segment|phase)=[^\\s]+.*$");

    public FlexiblePatternLogParser(LogStorageService logStorageService) {
        this.logStorageService = logStorageService;
    }

    public boolean supports(String line) {
        boolean hasTimestamp = TIMESTAMP_PATTERN.matcher(line).find();
        boolean hasLogLevel = LOG_LEVEL_PATTERN.matcher(line).find();
        boolean hasPhaseSegment = HAS_PHASE_SEGMENT.matcher(line).find();
        return hasTimestamp || hasLogLevel || hasPhaseSegment;
    }

    public Map<LogLineKey, String> parse(String line) {
        Matcher levelMatcher;
        LinkedHashMap<LogLineKey, String> result = new LinkedHashMap<LogLineKey, String>();
        Matcher timestampMatcher = TIMESTAMP_PATTERN.matcher(line);
        if (timestampMatcher.find()) {
            result.put(LogLineKey.TIMESTAMP, timestampMatcher.group());
            line = FlexiblePatternLogParser.removeAt((String)line, (int)timestampMatcher.start(), (int)timestampMatcher.end());
        }
        if ((levelMatcher = LOG_LEVEL_PATTERN.matcher(line)).find()) {
            result.put(LogLineKey.LOG_LEVEL, levelMatcher.group(1));
            line = FlexiblePatternLogParser.removeAt((String)line, (int)levelMatcher.start(), (int)levelMatcher.end());
        }
        String msg = line.trim();
        result.put(LogLineKey.MESSAGE, line);
        Matcher dm = Pattern.compile("(?<!\\S)data=").matcher(msg);
        if (dm.find()) {
            int start = dm.start();
            int end = dm.end();
            String dataVal = msg.substring(end).trim();
            result.put(LogLineKey.DATA, dataVal);
            msg = msg.substring(0, start).trim();
        }
        Matcher kvMatcher = KV_PATTERN.matcher(msg);
        while (kvMatcher.find()) {
            String key = kvMatcher.group(1);
            String value = kvMatcher.group(2);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (!LogLineKey.from((String)key).isPresent()) continue;
            result.put((LogLineKey)LogLineKey.from((String)key).get(), value);
        }
        return result;
    }

    public List<String> readLines(String executionId, long startOffset, long endOffset) {
        ArrayList<String> result = new ArrayList<String>();
        List block = this.logStorageService.readBlock(executionId, startOffset, endOffset);
        int left = 0;
        int right = 0;
        while (right < block.size()) {
            StringBuilder current = new StringBuilder((String)block.get(left));
            ++right;
            while (right < block.size() && !this.supports((String)block.get(right))) {
                current.append("\n").append((String)block.get(right));
                ++right;
            }
            result.add(current.toString());
            left = right;
        }
        return result;
    }

    private static String removeAt(String s, int start, int end) {
        return s.substring(0, start).trim() + " " + s.substring(end).trim();
    }
}

