/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.builder.strategies;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataError;
import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilder;
import com.becon.opencelium.backend.execution.logger.builder.strategies.OperationLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.dto.ErrorDetail;
import com.becon.opencelium.backend.execution.logger.enums.LogLineType;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;

public class OperationLogDataBuilder
implements PhaseBuilder {
    public LogDataMng build(PhaseContext phaseCtx, String execId, String flowId, Long connId) {
        ParsedLogLine parsed = phaseCtx.getParsedLogLine();
        PhaseCategory category = PhaseCategory.fromValue((PhaseType)((PhaseType)parsed.getStage()));
        LogDataMng logDataMng = new LogDataMng();
        logDataMng.setId(new ObjectId().toHexString());
        logDataMng.setExecutionId(execId);
        logDataMng.setConnectionId(connId);
        logDataMng.setFlowId(flowId);
        logDataMng.setIndexPath(phaseCtx.getProperty(LogLineKey.INDEX_PATH));
        logDataMng.setStatus(phaseCtx.getStatus());
        logDataMng.setStartOffset(parsed.getStartOffset());
        logDataMng.setEndOffset(Long.valueOf(phaseCtx.getEndOffset()));
        logDataMng.setLogLineType(LogLineType.PHASE);
        logDataMng.setType(category);
        Map flatProps = this.extractFlatProperties(phaseCtx.getProperties());
        logDataMng.setProperties(flatProps);
        SegmentAggregate agg = this.buildSegments(phaseCtx.getSegments());
        LinkedHashMap<String, Map> segment = new LinkedHashMap<String, Map>();
        if (!agg.request.isEmpty()) {
            segment.put("request", agg.request);
        }
        if (!agg.response.isEmpty()) {
            segment.put("response", agg.response);
        }
        logDataMng.setSegments(segment);
        ErrorDetail errorDetail = phaseCtx.getErrorDetail();
        if (phaseCtx.getErrorDetail() != null) {
            logDataMng.setError(this.mapCtxError(errorDetail));
        }
        return logDataMng;
    }

    private LogDataError mapCtxError(ErrorDetail errorDetail) {
        LogDataError error = new LogDataError();
        error.setMessage(errorDetail.getException().getProperty(LogLineKey.DATA));
        error.setErrorOfOriginPath(errorDetail.getErrorOriginPath());
        error.setStackTrace(errorDetail.getStackTrace());
        return error;
    }

    private Map<String, Object> extractFlatProperties(Map<LogLineKey, String> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        return props.entrySet().stream().filter(e -> this.isBaseKey((LogLineKey)e.getKey())).collect(Collectors.toMap(e -> ((LogLineKey)e.getKey()).getSrcName(), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private boolean isBaseKey(LogLineKey key) {
        String name = key.name();
        return !name.startsWith("HTTP_") && key != LogLineKey.URL && key != LogLineKey.DATA && key != LogLineKey.DURATION && key != LogLineKey.FLOWCHART_ID && key != LogLineKey.CONNECTOR_NAME && key != LogLineKey.EXECUTION_ID && key != LogLineKey.CONNECTION_ID && key != LogLineKey.INDEX_PATH && key != LogLineKey.HTTP_STATUS;
    }

    public LogDataError parseErrorInfo(String data) {
        if (data == null || data.isBlank()) {
            return new LogDataError("", Collections.emptyList());
        }
        String[] lines = data.split("\\R");
        String message = lines[0];
        ArrayList<String> stackTrace = new ArrayList<String>();
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i].strip();
            if (line.isEmpty()) continue;
            stackTrace.add(line);
        }
        return new LogDataError(message, stackTrace);
    }

    private SegmentAggregate buildSegments(List<SegmentContext> segments) {
        SegmentAggregate agg = new SegmentAggregate();
        for (SegmentContext ctx : segments) {
            Map p = ctx.getAllProperties();
            switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$SegmentType[ctx.getSegmentType().ordinal()]) {
                case 1: {
                    agg.request.put(LogLineKey.URL.getSrcName(), p.get(LogLineKey.URL));
                    agg.request.put(LogLineKey.HTTP_METHOD.getSrcName(), p.get(LogLineKey.HTTP_METHOD));
                    break;
                }
                case 2: {
                    agg.request.put("header", p.get(LogLineKey.DATA));
                    break;
                }
                case 3: {
                    agg.request.put("payload", p.get(LogLineKey.DATA));
                    break;
                }
                case 4: {
                    agg.response.put(LogLineKey.HTTP_STATUS.getSrcName(), p.get(LogLineKey.HTTP_STATUS));
                    agg.response.put(LogLineKey.DURATION.getSrcName(), p.get(LogLineKey.DURATION));
                    break;
                }
                case 5: {
                    agg.response.put("header", p.get(LogLineKey.DATA));
                    break;
                }
                case 6: {
                    agg.response.put("payload", p.get(LogLineKey.DATA));
                    break;
                }
            }
        }
        return agg;
    }
}

