/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.builder.strategies;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataError;
import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilder;
import com.becon.opencelium.backend.execution.logger.builder.strategies.IfLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.dto.ErrorDetail;
import com.becon.opencelium.backend.execution.logger.enums.LogLineType;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;

public class IfLogDataBuilder
implements PhaseBuilder {
    public LogDataMng build(PhaseContext phaseCtx, String execId, String flowId, Long connId) {
        ParsedLogLine parsed = phaseCtx.getParsedLogLine();
        PhaseCategory category = PhaseCategory.fromValue((PhaseType)((PhaseType)parsed.getStage()));
        LogDataMng logDataMng = new LogDataMng();
        logDataMng.setId(new ObjectId().toHexString());
        logDataMng.setExecutionId(execId);
        logDataMng.setConnectionId(connId);
        logDataMng.setFlowId(flowId);
        logDataMng.setIndexPath(phaseCtx.getProperty(LogLineKey.INDEX_PATH));
        logDataMng.setStatus(phaseCtx.getStatus());
        logDataMng.setStartOffset(phaseCtx.getStartOffset());
        logDataMng.setEndOffset(Long.valueOf(phaseCtx.getEndOffset()));
        logDataMng.setLogLineType(LogLineType.PHASE);
        logDataMng.setType(category);
        Map flatProps = this.extractFlatProperties(phaseCtx.getProperties());
        logDataMng.setProperties(flatProps);
        SegmentAggregate agg = this.buildSegments(phaseCtx.getSegments());
        LinkedHashMap<String, Object> segment = new LinkedHashMap<String, Object>();
        if (!agg.refs.isEmpty()) {
            segment.put(LogLineKey.REF.getSrcName(), agg.refs);
        }
        if (agg.ifResult != null) {
            segment.put(LogLineKey.RESULT.getSrcName(), agg.ifResult);
        }
        logDataMng.setSegments(segment);
        ErrorDetail errorDetail = phaseCtx.getErrorDetail();
        if (phaseCtx.getErrorDetail() != null) {
            logDataMng.setError(this.mapCtxError(errorDetail));
        }
        return logDataMng;
    }

    private Map<String, Object> extractFlatProperties(Map<LogLineKey, String> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        return props.entrySet().stream().filter(e -> this.excludeKey((LogLineKey)e.getKey())).collect(Collectors.toMap(e -> ((LogLineKey)e.getKey()).getSrcName(), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private boolean excludeKey(LogLineKey key) {
        return !Set.of(LogLineKey.CONNECTOR_NAME, LogLineKey.INDEX_PATH, LogLineKey.FLOWCHART_ID, LogLineKey.CONNECTION_ID, LogLineKey.EXECUTION_ID).contains(key);
    }

    private SegmentAggregate buildSegments(List<SegmentContext> segments) {
        SegmentAggregate agg = new SegmentAggregate();
        block4: for (SegmentContext ctx : segments) {
            Map p = ctx.getAllProperties();
            switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$SegmentType[ctx.getSegmentType().ordinal()]) {
                case 1: {
                    String ref = (String)p.get(LogLineKey.REF);
                    String data = (String)p.get(LogLineKey.DATA);
                    if (ref == null || data == null) continue block4;
                    agg.refs.add(Map.of(LogLineKey.REF.getSrcName(), ref, "value", data));
                    break;
                }
                case 2: {
                    agg.ifResult = (String)p.get(LogLineKey.DATA);
                    break;
                }
            }
        }
        return agg;
    }

    private LogDataError mapCtxError(ErrorDetail errorDetail) {
        LogDataError error = new LogDataError();
        error.setMessage(errorDetail.getException().getProperty(LogLineKey.DATA));
        error.setErrorOfOriginPath(errorDetail.getErrorOriginPath());
        error.setStackTrace(errorDetail.getStackTrace());
        return error;
    }
}

