/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.builder.strategies;

import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilder;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilderFactory;
import com.becon.opencelium.backend.execution.logger.builder.strategies.DefaultLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.builder.strategies.IfLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.builder.strategies.LoopLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.builder.strategies.OperationLogDataBuilder;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DefaultPhaseBuilderFactory
implements PhaseBuilderFactory {
    private final Map<PhaseCategory, PhaseBuilder> builderMap = new EnumMap(PhaseCategory.class);
    private final PhaseBuilder defaultBuilder = new DefaultLogDataBuilder();

    public DefaultPhaseBuilderFactory() {
        this.registerBuilders();
    }

    private void registerBuilders() {
        this.builderMap.put(PhaseCategory.OPERATION, new OperationLogDataBuilder());
        this.builderMap.put(PhaseCategory.IF, new IfLogDataBuilder());
        this.builderMap.put(PhaseCategory.LOOP, new LoopLogDataBuilder());
    }

    public PhaseBuilder getBuilder(PhaseCategory category) {
        return this.builderMap.getOrDefault(category, this.defaultBuilder);
    }
}

