/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.builder.strategies;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataError;
import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.builder.PhaseBuilder;
import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.dto.ErrorDetail;
import com.becon.opencelium.backend.execution.logger.enums.LogLineStage;
import com.becon.opencelium.backend.execution.logger.enums.LogLineType;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;

public class DefaultLogDataBuilder
implements PhaseBuilder {
    public LogDataMng build(PhaseContext context, String execId, String flowId, Long connId) {
        LogDataMng logDataMng = new LogDataMng();
        logDataMng.setId(new ObjectId().toHexString());
        logDataMng.setExecutionId(execId);
        logDataMng.setConnectionId(connId);
        logDataMng.setFlowId(flowId);
        logDataMng.setConnectorName(context.getProperty(LogLineKey.CONNECTOR_NAME));
        logDataMng.setFlowId((String)context.getProperties().get(LogLineKey.FLOWCHART_ID));
        logDataMng.setStatus(context.getStatus());
        logDataMng.setIndexPath((String)context.getProperties().get(LogLineKey.INDEX_PATH));
        logDataMng.setStartOffset(context.getStartOffset());
        logDataMng.setEndOffset(Long.valueOf(context.getEndOffset()));
        logDataMng.setLogLineType(LogLineType.PHASE);
        LogLineStage logLineStage = context.getParsedLogLine().getStage();
        if (logLineStage instanceof PhaseType) {
            PhaseType phaseType = (PhaseType)logLineStage;
            logDataMng.setType(PhaseCategory.fromValue((PhaseType)phaseType));
        } else {
            logDataMng.setType(PhaseCategory.UNKNOWN);
        }
        ErrorDetail errorDetail = context.getErrorDetail();
        if (context.getErrorDetail() != null) {
            logDataMng.setError(this.mapCtxError(errorDetail));
        }
        Map props = this.toStringKeyMap(context.getProperties());
        logDataMng.setProperties(props);
        return logDataMng;
    }

    private Map<String, Object> toStringKeyMap(Map<LogLineKey, String> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        return props.entrySet().stream().filter(k -> k.getValue() != null && this.excludeKey((LogLineKey)k.getKey())).collect(Collectors.toMap(e -> ((LogLineKey)e.getKey()).name(), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private LogDataError mapCtxError(ErrorDetail errorDetail) {
        LogDataError error = new LogDataError();
        error.setMessage(errorDetail.getException().getProperty(LogLineKey.DATA));
        error.setErrorOfOriginPath(errorDetail.getErrorOriginPath());
        error.setStackTrace(errorDetail.getStackTrace());
        return error;
    }

    private boolean excludeKey(LogLineKey key) {
        return !Set.of(LogLineKey.CONNECTOR_NAME, LogLineKey.INDEX_PATH, LogLineKey.FLOWCHART_ID, LogLineKey.CONNECTION_ID, LogLineKey.EXECUTION_ID).contains(key);
    }
}

