/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.buffer;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.buffer.LogBlockBuffer;
import com.becon.opencelium.backend.execution.logger.buffer.LogBlockKeyExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class InMemoryLogBlockBuffer
implements LogBlockBuffer {
    private final int batchSize;
    private final LogBlockKeyExtractor keyExtractor;
    private final List<LogDataMng> buffer;
    private final Map<String, LogDataMng> index;

    public InMemoryLogBlockBuffer(int batchSize, LogBlockKeyExtractor keyExtractor) {
        this.batchSize = batchSize;
        this.keyExtractor = keyExtractor;
        this.buffer = new ArrayList(batchSize);
        this.index = new HashMap(batchSize * 2);
    }

    public synchronized List<LogDataMng> buffer(LogDataMng block) {
        String key = this.keyExtractor.extractKey(block);
        this.buffer.add(block);
        this.index.put(key, block);
        if (this.buffer.size() >= this.batchSize) {
            return this.flushInternal();
        }
        return List.of();
    }

    public synchronized Optional<LogDataMng> findInBuffer(LogDataMng example) {
        String key = this.keyExtractor.extractKey(example);
        return Optional.ofNullable((LogDataMng)this.index.get(key));
    }

    public synchronized List<LogDataMng> flushAll() {
        if (this.buffer.isEmpty()) {
            return List.of();
        }
        return this.flushInternal();
    }

    private List<LogDataMng> flushInternal() {
        ArrayList<LogDataMng> copy = new ArrayList<LogDataMng>(this.buffer);
        this.buffer.clear();
        this.index.clear();
        return copy;
    }
}

