/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.dto.LogDataDTO;
import com.becon.opencelium.backend.execution.logger.enums.LogDetailLevel;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.parser.ParsedLogLineBuilder;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import com.becon.opencelium.backend.execution.logger.service.LogDataService;
import com.becon.opencelium.backend.execution.logger.service.LogDataServiceImp;
import com.becon.opencelium.backend.execution.logger.tracker.ExecutionTracker;
import com.becon.opencelium.backend.execution.logger.tracker.ExecutionTrackerImpl;
import com.becon.opencelium.backend.utility.ApplicationContextUtility;
import java.util.Optional;

public class LogLineDispatcher {
    private final ThreadLocal<ExecutionTracker> tls = new ThreadLocal();
    private final ParsedLogLineBuilder parsedLogLineBuilder = (ParsedLogLineBuilder)ApplicationContextUtility.getBean(ParsedLogLineBuilder.class);
    private final LogDataService logMetaDataService = (LogDataService)ApplicationContextUtility.getBean(LogDataServiceImp.class);

    public Optional<LogDataDTO> dispatch(String logLine, long startOffset, long endOffset) {
        return this.dispatch(logLine, startOffset, endOffset, LogDetailLevel.LIGHTWEIGHT);
    }

    public Optional<LogDataDTO> dispatch(String logLine, long startOffset, long endOffset, LogDetailLevel logLevelMode) {
        ParsedLogLine parsed = this.parsedLogLineBuilder.build(logLine, startOffset, endOffset);
        if (parsed.getStage() == PhaseType.EXECUTION_START) {
            this.tls.set(new ExecutionTrackerImpl(logLevelMode));
        }
        ExecutionTracker tracker = (ExecutionTracker)this.tls.get();
        if (parsed.getStage() == PhaseType.EXECUTION_END) {
            this.tls.remove();
        }
        if (tracker == null) {
            return Optional.empty();
        }
        Optional logData = tracker.buildLogData(parsed);
        if (logData.isEmpty()) {
            return Optional.empty();
        }
        LogDataMng data = (LogDataMng)logData.get();
        this.logMetaDataService.bufferAndFlush(data);
        return this.logMetaDataService.toDto(data);
    }
}

