/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AsyncLogDispatcher
implements AutoCloseable {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private final Thread worker;
    private volatile boolean running = true;

    public AsyncLogDispatcher(String threadName) {
        this.worker = new Thread(() -> this.processLoop(), threadName);
        this.worker.start();
    }

    public void submit(Runnable task) {
        if (!this.running) {
            return;
        }
        this.queue.offer(task);
    }

    private void processLoop() {
        block14: {
            Runnable task;
            block11: while (true) {
                while (this.running || !this.queue.isEmpty()) {
                    try {
                        task = (Runnable)this.queue.take();
                    }
                    catch (InterruptedException ie) {
                        if (this.running) continue;
                        break block14;
                    }
                    try {
                        task.run();
                        continue block11;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block14;
                {
                    continue block11;
                    break;
                }
                break;
            }
            finally {
                while ((task = (Runnable)this.queue.poll()) != null) {
                    try {
                        task.run();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this.running = false;
        this.worker.interrupt();
        try {
            this.worker.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

