/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution;

import com.becon.opencelium.backend.configuration.cutomizer.RestCustomizer;
import com.becon.opencelium.backend.database.mysql.entity.MaskingRule;
import com.becon.opencelium.backend.execution.ConnectorExecutor;
import com.becon.opencelium.backend.execution.ExecutionManager;
import com.becon.opencelium.backend.execution.ExecutionManagerImpl;
import com.becon.opencelium.backend.execution.logger.OcLogger;
import com.becon.opencelium.backend.execution.logger.msg.ExecutionLog;
import com.becon.opencelium.backend.execution.masking.MaskingService;
import com.becon.opencelium.backend.execution.masking.MaskingServiceImp;
import com.becon.opencelium.backend.execution.oc721.Connector;
import com.becon.opencelium.backend.execution.oc721.FieldBind;
import com.becon.opencelium.backend.execution.oc721.Operation;
import com.becon.opencelium.backend.resource.execution.ConnectionEx;
import com.becon.opencelium.backend.resource.execution.ConnectorEx;
import com.becon.opencelium.backend.resource.execution.ExecutionObj;
import com.becon.opencelium.backend.resource.execution.ProxyEx;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;

public class ConnectionExecutor {
    private final Map<String, Object> webhookVars;
    private final ConnectionEx connection;
    private final OcLogger<ExecutionLog> executionLogger;
    private final MaskingService masking;
    private final ProxyEx proxy;
    private ExecutionManager executionManager;

    public ConnectionExecutor(ExecutionObj executionObj, OcLogger<ExecutionLog> executionLogger, List<MaskingRule> rules) {
        this.webhookVars = executionObj.getWebhookVars();
        this.connection = executionObj.getConnection();
        this.proxy = executionObj.getProxy();
        this.executionLogger = executionLogger;
        this.masking = new MaskingServiceImp(rules);
    }

    public void start() {
        Connector source = Connector.fromEx((ConnectorEx)this.connection.getSource());
        Connector target = Connector.fromEx((ConnectorEx)this.connection.getTarget());
        List fieldBind = this.connection.getFieldBind().stream().map(FieldBind::fromEx).collect(Collectors.toList());
        this.executionManager = new ExecutionManagerImpl(this.webhookVars, source, target, fieldBind);
        ConnectorExecutor sourceEx = new ConnectorExecutor(this.connection.getSource(), this.executionManager, this.getRestTemplate(source), this.executionLogger, this.masking, "source");
        ConnectorExecutor targetEx = new ConnectorExecutor(this.connection.getTarget(), this.executionManager, this.getRestTemplate(target), this.executionLogger, this.masking, "target");
        sourceEx.start();
        targetEx.start();
    }

    public List<Operation> getOperations() {
        if (this.executionManager == null) {
            return List.of();
        }
        return this.executionManager.getAllOperations();
    }

    private RestTemplate getRestTemplate(Connector connector) {
        int timeout = connector.getTimeout();
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[]{new RestCustomizer(this.proxy.getHost(), this.proxy.getPort(), this.proxy.getUser(), this.proxy.getPassword(), connector.isSslCert(), timeout)});
        if (timeout > 0) {
            restTemplateBuilder.setReadTimeout(Duration.ofMillis(timeout));
        }
        return restTemplateBuilder.build();
    }
}

