/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.entity.Webhook;
import com.becon.opencelium.backend.database.mysql.repository.WebhookRepository;
import com.becon.opencelium.backend.database.mysql.service.SchedulerServiceImp;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.WebhookService;
import com.becon.opencelium.backend.exception.GeneralServiceException;
import com.becon.opencelium.backend.resource.webhook.WebhookParamDTO;
import com.becon.opencelium.backend.resource.webhook.WebhookResource;
import com.becon.opencelium.backend.resource.webhook.WebhookTokenResource;
import com.becon.opencelium.backend.security.JwtTokenUtil;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WebhookServiceImp
implements WebhookService {
    @Autowired
    private WebhookRepository webhookRepository;
    @Autowired
    private UserServiceImpl userService;
    @Lazy
    @Autowired
    private SchedulerServiceImp schedulerService;
    @Autowired
    private JwtTokenUtil jwtTokenUtil;

    public Optional<WebhookTokenResource> getTokenObject(String token) {
        JWTClaimsSet claims = this.jwtTokenUtil.getAllClaimsFromToken(token);
        String uuid = claims.getClaim("uuid").toString();
        String tmp = claims.getClaim("userId").toString();
        int schedulerId = ((Long)claims.getClaim("schedulerId")).intValue();
        int userId = Integer.parseInt(tmp);
        boolean userExists = this.userService.existsById(userId);
        boolean schedulerExists = this.schedulerService.existsById(schedulerId);
        if (!schedulerExists) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        if (!userExists) {
            throw new RuntimeException("USER_NOT_FOUND");
        }
        WebhookTokenResource webhookToken = new WebhookTokenResource(userId, uuid, schedulerId);
        return Optional.of(webhookToken);
    }

    public Webhook save(int userId, Scheduler scheduler) {
        Webhook webhook = new Webhook();
        UUID uuid = UUID.randomUUID();
        String token = this.generateWebhookToken(userId, uuid.toString(), scheduler.getId());
        webhook.setUuid(uuid.toString());
        webhook.setToken(token);
        webhook.setScheduler(scheduler);
        return (Webhook)this.webhookRepository.save((Object)webhook);
    }

    public String generateWebhookToken(int userId, String uuid, int schedulerId) {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject("webhook").claim("userId", (Object)userId).claim("uuid", (Object)uuid).claim("schedulerId", (Object)schedulerId).jwtID(Long.toString(schedulerId)).build();
        return this.jwtTokenUtil.generateToken(claimsSet);
    }

    public int getConnectionIdByUrl() {
        return 0;
    }

    public Optional<Webhook> findById(int id) {
        return this.webhookRepository.findById((Object)id);
    }

    public Optional<Webhook> findBySchedulerId(int id) {
        return this.webhookRepository.findBySchedulerId(id);
    }

    public Optional<Webhook> findByUIID(String uuid) {
        return this.webhookRepository.findByUuid(uuid);
    }

    public String buildUrl(Webhook webhook) {
        return "./webhook/execute/" + webhook.getToken();
    }

    public void deleteById(int id) {
        this.webhookRepository.deleteById((Object)id);
    }

    public WebhookResource toResource(Webhook webhook) {
        WebhookResource webhookResource = new WebhookResource();
        webhookResource.setWebhookId(webhook.getId());
        webhookResource.setUrl(this.buildUrl(webhook));
        return webhookResource;
    }

    public void deleteAllBySchedulerId(int id) {
        this.webhookRepository.deleteAllBySchedulerId(id);
    }

    public boolean existsBySchedulerId(int id) {
        return this.webhookRepository.existsBySchedulerId(id);
    }

    public WebhookParamDTO toParamResource(String param) {
        WebhookParamDTO webhookParamDTO = new WebhookParamDTO();
        String[] var = param.split(":");
        if (var.length == 0) {
            throw new RuntimeException("One of webhook parameters is empty");
        }
        webhookParamDTO.setName(var[0]);
        if (var.length == 1) {
            webhookParamDTO.setType("string");
        } else {
            webhookParamDTO.setType(var[1]);
        }
        return webhookParamDTO;
    }

    public Map<String, Object> mergeParams(Map<String, Object> primaryParams, Map<String, Object> additionalParams) {
        if (CollectionUtils.isEmpty(additionalParams)) {
            return primaryParams;
        }
        if (CollectionUtils.isEmpty(primaryParams)) {
            return additionalParams;
        }
        boolean conflicted = false;
        ArrayList<String> conflictedParams = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : primaryParams.entrySet()) {
            if (!additionalParams.containsKey(entry.getKey())) continue;
            conflicted = true;
            conflictedParams.add(entry.getKey());
        }
        if (conflicted) {
            throw new GeneralServiceException("INVALID_DATA", "[%s] parameters are present on both query and body parameters".formatted(String.join((CharSequence)",", conflictedParams)));
        }
        primaryParams.putAll(additionalParams);
        return primaryParams;
    }

    public Map<String, Object> convertToArrayList(Map<String, Object> inputMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.startsWith("[") && strValue.endsWith("]")) {
                    result.put(key, WebhookServiceImp.parseStringToArrayList((String)strValue));
                    continue;
                }
                result.put(key, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static Object parseStringToArrayList(String strValue) {
        if ((strValue = strValue.substring(1, strValue.length() - 1)).contains("[")) {
            return WebhookServiceImp.parseNestedArray((String)strValue);
        }
        return WebhookServiceImp.parseSimpleArray((String)strValue);
    }

    private static ArrayList<Object> parseSimpleArray(String strValue) {
        String[] values;
        ArrayList<Object> list = new ArrayList<Object>();
        for (String val : values = strValue.split(",")) {
            if ((val = val.trim()).matches("-?\\d+(\\.\\d+)?")) {
                if (val.contains(".")) {
                    list.add(Double.parseDouble(val));
                    continue;
                }
                list.add(Integer.parseInt(val));
                continue;
            }
            list.add(val);
        }
        return list;
    }

    private static ArrayList<Object> parseNestedArray(String strValue) {
        ArrayList<Object> outerList = new ArrayList<Object>();
        int level = 0;
        StringBuilder sb = new StringBuilder();
        for (char ch : strValue.toCharArray()) {
            if (ch == '[') {
                if (level > 0) {
                    sb.append(ch);
                }
                ++level;
                continue;
            }
            if (ch == ']') {
                if (--level > 0) {
                    sb.append(ch);
                }
                if (level != 0) continue;
                outerList.add(WebhookServiceImp.parseStringToArrayList((String)("[" + sb.toString() + "]")));
                sb.setLength(0);
                continue;
            }
            if (level <= 0) continue;
            sb.append(ch);
        }
        return outerList;
    }
}

