/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.repository.UserRepository;
import com.becon.opencelium.backend.database.mysql.repository.UserRoleRepository;
import com.becon.opencelium.backend.database.mysql.service.SessionServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserDetailServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.database.mysql.service.WidgetSettingServiceImp;
import com.becon.opencelium.backend.enums.AuthMethod;
import com.becon.opencelium.backend.resource.request.UserRequestResource;
import com.becon.opencelium.backend.resource.user.UserResource;
import com.becon.opencelium.backend.utility.EmailUtility;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Lazy
    @Autowired
    private UserDetailServiceImpl detailService;
    @Autowired
    private SessionServiceImpl sessionService;
    @Autowired
    private WidgetSettingServiceImp widgetSettingServiceImp;

    public Optional<User> findByEmail(String email) {
        return this.userRepository.findByEmail(email);
    }

    public Optional<User> findByUsername(String username) {
        return this.userRepository.findByUsernameAndAuthMethod(username, AuthMethod.LDAP);
    }

    public Optional<User> findById(int id) {
        return this.userRepository.findOneById(id);
    }

    public User getById(Integer userId) {
        return (User)this.findById(userId.intValue()).orElseThrow(() -> new RuntimeException("USER_NOT_FOUND"));
    }

    public User save(User user) {
        if (EmailUtility.isEmail((String)user.getEmail())) {
            return (User)this.userRepository.save((Object)user);
        }
        throw new IllegalArgumentException("Invalid email is supplied to User dto");
    }

    public boolean existsByEmail(String email) {
        return this.userRepository.existsByEmail(email);
    }

    public boolean existsById(int id) {
        return this.userRepository.existsById((Object)id);
    }

    public void deleteById(int id) {
        this.userRepository.deleteOneById(id);
    }

    public List<User> findAll() {
        return this.userRepository.findAll();
    }

    public User fromResource(UserResource userResource) {
        return null;
    }

    @Transactional
    public User requestToEntity(UserRequestResource userRequestResource) {
        User user = new User();
        User userDb = this.userRepository.findById((Object)userRequestResource.getUserId()).orElse(null);
        UserRole userRole = this.userRoleRepository.findById((Object)userRequestResource.getUserGroup()).orElse(null);
        if (userDb == null && (userRequestResource.getPassword() == null || userRequestResource.getPassword().isEmpty())) {
            throw new RuntimeException("PASSWORD_IS_NULL");
        }
        if (userDb != null && userRequestResource.getPassword() != null && !userRequestResource.getPassword().isEmpty()) {
            user.setPassword(this.encodePassword(userRequestResource.getPassword()));
        }
        if (userDb != null && (userRequestResource.getPassword() == null || userRequestResource.getPassword().isEmpty())) {
            user.setPassword(userDb.getPassword());
        }
        if (userDb != null) {
            userRequestResource.getUserDetail().setProfilePicture(userDb.getUserDetail().getProfilePicture());
        }
        if (userDb == null && (userRequestResource.getPassword() != null || userRequestResource.getPassword().isEmpty())) {
            String encPass = userRequestResource.getPassword();
            user.setPassword(this.encodePassword(encPass));
        }
        UserDetail userDetail = this.detailService.toEntity(userRequestResource.getUserDetail());
        Session session = this.sessionService.findByUserId(userRequestResource.getUserId()).orElse(null);
        user.setId(userRequestResource.getUserId());
        user.setUserRole(userRole);
        user.setSession(session);
        user.setEmail(userRequestResource.getEmail());
        user.setUserDetail(userDetail);
        if (userDb != null) {
            user.setAuthMethod(userDb.getAuthMethod());
            user.setTotpProcessCompleted(userDb.isTotpProcessCompleted());
            user.setTotpSecretKey(userDb.getTotpSecretKey());
            user.setUsername(userDb.getUsername());
        }
        userDetail.setId(userRequestResource.getUserId());
        userDetail.setUser(user);
        return user;
    }

    public UserResource toResource(User entity) {
        return new UserResource(entity);
    }

    public User toEntity(UserResource resource) {
        List widgetSettings = resource.getWidgetSettings().stream().map(wsr -> this.widgetSettingServiceImp.toEntity(wsr, resource.getUserId())).collect(Collectors.toList());
        return new User(resource, widgetSettings);
    }

    public String encodePassword(String password) {
        return this.bCryptPasswordEncoder.encode((CharSequence)password);
    }

    public User getCurrentUser() {
        Object object;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (object = authentication.getPrincipal()) instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)object;
            return (User)this.findByEmail(userDetails.getUsername()).get();
        }
        return null;
    }
}

